/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.iterator.tests;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.iterator.AllPairsIterator;
import cc.mallet.cluster.iterator.ClusterSampleIterator;
import cc.mallet.cluster.iterator.NeighborIterator;
import cc.mallet.cluster.iterator.PairSampleIterator;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.Randoms;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestIterators
extends TestCase {
    public TestIterators(String name) {
        super(name);
    }

    private Clustering generateClustering(InstanceList instances) {
        int[] labels = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2, 2};
        return new Clustering(instances, 3, labels);
    }

    public void testEvaluators() {
        Instance instance;
        Randoms random = new Randoms(1);
        InstanceList instances = new InstanceList(random, 100, 2).subList(0, 10);
        System.err.println(instances.size() + " instances");
        Clustering clustering = this.generateClustering(instances);
        System.err.println("clustering=" + clustering);
        System.err.println("ClusterSampleIterator");
        NeighborIterator iter = new ClusterSampleIterator(clustering, random, 0.5, 10);
        while (iter.hasNext()) {
            instance = (Instance)iter.next();
            System.err.println(instance.getData() + "\n");
        }
        System.err.println("\n\nPairSampleIterator");
        iter = new PairSampleIterator(clustering, random, 0.5, 10);
        while (iter.hasNext()) {
            instance = (Instance)iter.next();
            System.err.println(instance.getData() + "\n");
        }
        System.err.println("\n\nAllPairsIterator");
        iter = new AllPairsIterator(clustering);
        while (iter.hasNext()) {
            instance = (Instance)iter.next();
            System.err.println(instance.getData() + "\n");
        }
    }

    public static Test suite() {
        return new TestSuite((Class<?>)TestIterators.class);
    }

    @Override
    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run(TestIterators.suite());
    }
}

