/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.relation;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.IWarningSource;
import com.amazon.sqlengine.executor.conversions.ConversionUtil;
import com.amazon.sqlengine.executor.conversions.ISqlConverter;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IETNodeVisitor;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.relation.ETUnaryRelationalExpr;
import com.amazon.support.IWarningListener;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

public class ETRelationalConvert
extends ETUnaryRelationalExpr
implements IWarningSource {
    private List<ISqlConverter> m_converters;
    private List<IColumn> m_metadatas;
    private List<ETDataRequest> m_columnData;
    private IWarningListener m_warningListener;
    private final boolean m_errorOnTruncation;

    public ETRelationalConvert(List<IColumn> list, List<ISqlConverter> list2, boolean bl, ETRelationalExpr eTRelationalExpr, boolean[] blArray) throws ErrorException {
        super(eTRelationalExpr, blArray);
        this.m_errorOnTruncation = bl;
        int n = eTRelationalExpr.getColumnCount();
        if (list2.size() != n || list.size() != n) {
            throw new IllegalArgumentException("Column count mismatch");
        }
        this.m_metadatas = list;
        this.m_converters = new ArrayList<ISqlConverter>(list2.size());
        this.m_converters.addAll(list2);
        this.m_columnData = new ArrayList<ETDataRequest>();
        for (int i = 0; i < eTRelationalExpr.getColumnCount(); ++i) {
            ISqlConverter iSqlConverter = this.m_converters.get(i);
            if (iSqlConverter != null) {
                this.m_columnData.add(new ETDataRequest(this.getOperand().getColumn(i)));
                continue;
            }
            this.m_columnData.add(null);
        }
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public IColumn getColumn(int n) {
        if (n < 0 || n >= this.m_metadatas.size()) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        return this.m_metadatas.get(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_metadatas.size();
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.getOperand().getRowCount();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        ETDataRequest eTDataRequest2 = this.m_columnData.get(n);
        if (eTDataRequest2 == null) {
            return this.getOperand().retrieveData(n, eTDataRequest);
        }
        boolean bl = this.getOperand().retrieveData(n, eTDataRequest2);
        if (bl) {
            throw new IllegalStateException("Has more data after retrieve all data");
        }
        return ConversionUtil.doConvert(eTDataRequest, eTDataRequest2.getData(), this.m_converters.get(n), this.m_warningListener, this.m_errorOnTruncation);
    }

    @Override
    protected boolean doMove() throws ErrorException {
        return this.getOperand().doMove();
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        if (iWarningListener == null) {
            throw new IllegalArgumentException("listener is null.");
        }
        this.m_warningListener = iWarningListener;
    }
}

