/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import weka.core.OptionMetadata;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="MakeResourceIntensive", category="Flow", toolTipText="Makes downstream connected steps resource intensive (or not). This shifts processing of such steps between the main step executor<br>service and the high resource executor service or vice versa.", iconPath="weka/gui/knowledgeflow/icons/DiamondPlain.gif")
public class MakeResourceIntensive
extends BaseStep {
    private static final long serialVersionUID = -5670771681991035130L;
    protected boolean m_setAsResourceIntensive = true;

    @OptionMetadata(displayName="Make downstream step(s) high resource", description="<html>Makes downstream connected steps resource intensive (or not)<br>This shifts processing of such steps between the main step executor service and the high resource executor service or vice versa.</html>")
    public void setMakeResourceIntensive(boolean resourceIntensive) {
        this.m_setAsResourceIntensive = resourceIntensive;
    }

    public boolean getMakeResourceIntensive() {
        return this.m_setAsResourceIntensive;
    }

    @Override
    public void stepInit() throws WekaException {
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("dataSet", "trainingSet", "testSet", "batchClassifier", "batchClusterer", "batchAssociator");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        Set<String> inConnTypes = this.getStepManager().getIncomingConnections().keySet();
        return new ArrayList<String>(inConnTypes);
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        String connType = data.getConnectionName();
        List<StepManager> connected = this.getStepManager().getOutgoingConnectedStepsOfConnectionType(connType);
        for (StepManager m : connected) {
            this.getStepManager().logDetailed("Setting " + m.getName() + " as resource intensive: " + this.m_setAsResourceIntensive);
            ((StepManagerImpl)m).setStepIsResourceIntensive(this.m_setAsResourceIntensive);
        }
        this.getStepManager().outputData(data);
    }
}

