/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.stat.correlation.Covariance;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.subgroup.ISubgroup;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.quality.IQualityFunction;
import org.vikamine.kernel.subgroup.target.NumericMultiAttributeTarget;
import org.vikamine.kernel.util.VKMUtil;

public class HotellingTSquareBasedQF
implements IQualityFunction {
    private static final String ID = "HotellingTSquareBasedQF";
    private static final String NAME = "Hotelling-T-Square-Based QF";
    private double[] numericTargetAttributeValuesMeansInPopulation;
    private final double a;

    public HotellingTSquareBasedQF(double a) {
        this.a = a;
    }

    @Override
    public IQualityFunction clone() {
        return new HotellingTSquareBasedQF(this.a);
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isApplicable(ISubgroup<DataRecord> subgroup) {
        if (!(subgroup instanceof SG)) {
            return false;
        }
        SG sg = (SG)subgroup;
        return sg.getTarget() != null && sg.getTarget().isNumeric();
    }

    private List<Attribute> getAttributes(ISubgroup<DataRecord> subgroup) {
        return new ArrayList<Attribute>(((NumericMultiAttributeTarget)((SG)subgroup).getTarget()).getAttributes());
    }

    private double[][] getNumericTargetAttributeValues(ISubgroup<DataRecord> subgroup) {
        List<Attribute> attributes = this.getAttributes(subgroup);
        int subgroupSize = VKMUtil.asList(subgroup.iterator()).size();
        double[][] values = new double[subgroupSize][attributes.size()];
        int i = 0;
        for (DataRecord record : subgroup) {
            int j = 0;
            for (Attribute attribute : attributes) {
                double value;
                values[i][j] = value = record.getValue(attribute);
                ++j;
            }
            ++i;
        }
        return values;
    }

    public void cachePopulationTargetParameters(ISubgroup<DataRecord> subgroup) {
        List<Attribute> attributes = this.getAttributes(subgroup);
        DataView dataview = ((SG)subgroup).getPopulation();
        this.numericTargetAttributeValuesMeansInPopulation = new double[attributes.size()];
        int pos = 0;
        for (Attribute attribute : attributes) {
            int size = 0;
            double mean = 0.0;
            for (DataRecord record : dataview) {
                mean += record.getValue(attribute);
                ++size;
            }
            this.numericTargetAttributeValuesMeansInPopulation[pos] = mean /= (double)size;
            ++pos;
        }
    }

    @Override
    public double evaluate(ISubgroup<DataRecord> subgroup) {
        List<Attribute> attributes = this.getAttributes(subgroup);
        double[][] numericTargetAttributeValuesMatrixArray = this.getNumericTargetAttributeValues(subgroup);
        BlockRealMatrix numericTargetAttributeValuesMatrix = new BlockRealMatrix(numericTargetAttributeValuesMatrixArray);
        double[] numericTargetAttributeValuesMeans = new double[attributes.size()];
        Mean mean = new Mean();
        int i = 0;
        while (i < attributes.size()) {
            double attributeMean;
            numericTargetAttributeValuesMeans[i] = attributeMean = mean.evaluate(numericTargetAttributeValuesMatrix.getColumn(i));
            ++i;
        }
        RealMatrix covarianceMatrix = new Covariance(numericTargetAttributeValuesMatrix).getCovarianceMatrix();
        double[] meanDiff = new double[attributes.size()];
        int i2 = 0;
        while (i2 < attributes.size()) {
            meanDiff[i2] = numericTargetAttributeValuesMeans[i2] - this.numericTargetAttributeValuesMeansInPopulation[i2];
            ++i2;
        }
        ArrayRealVector meanDiffVector = new ArrayRealVector(meanDiff);
        try {
            RealVector inverseCoverianceMatrix = MatrixUtils.inverse(covarianceMatrix).operate(meanDiffVector);
            RealMatrix meanDiffVectorTransposed = MatrixUtils.createRowRealMatrix(meanDiff);
            RealVector resultElement = meanDiffVectorTransposed.operate(inverseCoverianceMatrix);
            double result = resultElement.getEntry(0);
            double subgroupSize = ((SG)subgroup).getStatistics().getSubgroupSize();
            double numAttributes = attributes.size();
            double sizeFactor = subgroupSize * (subgroupSize - numAttributes) / (numAttributes * (subgroupSize - 1.0));
            sizeFactor = Math.pow(sizeFactor, this.a);
            return result *= sizeFactor;
        }
        catch (SingularMatrixException e) {
            return Double.NaN;
        }
    }
}

