/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.List;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.quality.IQualityFunction;
import org.vikamine.kernel.subgroup.quality.constraints.IConstraint;
import org.vikamine.kernel.subgroup.quality.functions.InverseQF;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.SGTarget;

public abstract class AbstractMiningTask {
    protected List<SGSelector> searchSpace;
    protected SGTarget target;
    protected Class methodType;
    protected IQualityFunction qualityFunction;
    private List<IConstraint> constraints;
    protected SG initialSG;
    protected Ontology ontology;
    protected boolean weightedCovering;
    protected int maxSGCount = 10;
    protected double minQualityLimit = 0.0;
    protected double minSubgroupSize = 1.0;
    protected double minTPSupportAbsolute = 0.0;
    protected double minTPSupportRelative = 0.0;
    protected boolean invertQualityFunction = false;
    protected boolean suppressStrictlyIrrelevantSubgroups;
    protected boolean ignoreDefaultValues;

    public List<SGSelector> getSearchSpace() {
        return this.searchSpace;
    }

    public void setSearchSpace(List<SGSelector> searchSpace) {
        this.searchSpace = searchSpace;
    }

    public void addConstraint(IConstraint constraint) {
        this.constraints.add(constraint);
    }

    public void setConstraints(List<IConstraint> constraints) {
        this.constraints = constraints;
    }

    public boolean isIgnoreDefaultValues() {
        return this.ignoreDefaultValues;
    }

    public void setIgnoreDefaultValues(boolean ignoreDefaultValues) {
        this.ignoreDefaultValues = ignoreDefaultValues;
    }

    public AbstractMiningTask() {
        this.constraints = new ArrayList<IConstraint>();
        this.searchSpace = new ArrayList<SGSelector>();
    }

    public AbstractMiningTask(List<SGSelector> searchSpace, SGTarget target, Class methodtype, IQualityFunction function, SG initialSG, Ontology ont, boolean wc, boolean ignoreDefaults) {
        this.searchSpace = searchSpace;
        this.target = target;
        this.methodType = methodtype;
        this.qualityFunction = function;
        this.initialSG = initialSG;
        this.ontology = ont;
        this.weightedCovering = wc;
        this.ignoreDefaultValues = ignoreDefaults;
        this.constraints = new ArrayList<IConstraint>();
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (SGSelector sel : this.searchSpace) {
            Attribute att = sel.getAttribute();
            if (result.contains(att)) continue;
            result.add(att);
        }
        return result;
    }

    public IQualityFunction getQualityFunction() {
        if (this.isInvertQualityFunction()) {
            return new InverseQF(this.qualityFunction);
        }
        return this.qualityFunction;
    }

    public SG getInitialSG() {
        return this.initialSG;
    }

    public int getMaxSGCount() {
        return this.maxSGCount;
    }

    public Class getMethodType() {
        return this.methodType;
    }

    public double getMinQualityLimit() {
        return this.minQualityLimit;
    }

    public double getMinSubgroupSize() {
        return this.minSubgroupSize;
    }

    public double getMinTPSupportAbsolute() {
        return this.minTPSupportAbsolute;
    }

    public double getMinTPSupportRelative() {
        return this.minTPSupportRelative;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public SGTarget getTarget() {
        return this.target;
    }

    public boolean isInvertQualityFunction() {
        return this.invertQualityFunction;
    }

    public boolean isSuppressStrictlyIrrelevantSubgroups() {
        return this.suppressStrictlyIrrelevantSubgroups;
    }

    public boolean isWeightedCovering() {
        return this.weightedCovering;
    }

    public void setQualityFunction(IQualityFunction function) {
        this.qualityFunction = function;
    }

    public void setInitialSG(SG initialSG) {
        this.initialSG = initialSG;
    }

    public void setInvertQualityFunction(boolean invertQualityFunction) {
        this.invertQualityFunction = invertQualityFunction;
    }

    public void setMaxSGCount(int maxSGCount) {
        this.maxSGCount = maxSGCount;
    }

    public void setMethodType(Class methodType) {
        this.methodType = methodType;
    }

    public void setMinQualityLimit(double minQualityLimit) {
        this.minQualityLimit = minQualityLimit;
    }

    public void setMinSubgroupSize(double minSGSize) {
        this.minSubgroupSize = minSGSize;
    }

    public void setMinTPSupportAbsolute(double minTPSupportAbsolute) {
        this.minTPSupportAbsolute = minTPSupportAbsolute;
    }

    public void setMinTPSupportRelative(double minTPSupportRelative) {
        this.minTPSupportRelative = minTPSupportRelative;
    }

    public void setOntology(Ontology ont) {
        this.ontology = ont;
    }

    public void setSuppressStrictlyIrrelevantSubgroups(boolean suppressStrictlyIrrelevantSubgroups) {
        this.suppressStrictlyIrrelevantSubgroups = suppressStrictlyIrrelevantSubgroups;
    }

    public void setTarget(SGTarget target) {
        this.target = target;
    }

    public void setWeightedCovering(boolean wc) {
        this.weightedCovering = wc;
    }
}

