/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.util.BitSet;
import java.util.List;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataRecordIteration;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.BooleanTarget;

public class BitSetUtils {
    public static BitSet generateBitSet(SGSelector lws, DataRecordIteration iteration) {
        BitSet selectorBitSet = new BitSet(iteration.size());
        int i = 0;
        for (DataRecord dr : iteration) {
            if (lws.isContainedInInstance(dr)) {
                selectorBitSet.set(i);
            }
            ++i;
        }
        return selectorBitSet;
    }

    public static BitSet generateBitSet(SGSelector lws, List<DataRecord> iteration) {
        BitSet selectorBitSet = new BitSet(iteration.size());
        int i = 0;
        for (DataRecord dr : iteration) {
            if (lws.isContainedInInstance(dr)) {
                selectorBitSet.set(i);
            }
            ++i;
        }
        return selectorBitSet;
    }

    public static BitSet generateBitSet(SG sg, DataRecordIteration iteration) {
        BitSet selectorBitSet = new BitSet(iteration.size());
        int i = 0;
        for (DataRecord dr : iteration) {
            if (sg.getSGDescription().isMatching(dr)) {
                selectorBitSet.set(i);
            }
            ++i;
        }
        return selectorBitSet;
    }

    public static BitSet generatePositives(SG sg, DataRecordIteration iteration) {
        BooleanTarget target = (BooleanTarget)sg.getTarget();
        BitSet selectorBitSet = new BitSet(iteration.size());
        int i = 0;
        for (DataRecord dr : iteration) {
            if (sg.getSGDescription().isMatching(dr) && target.isPositive(dr)) {
                selectorBitSet.set(i);
            }
            ++i;
        }
        return selectorBitSet;
    }
}

