/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdistmulti.BiNormalDist;
import umontreal.iro.lecuyer.util.Num;

public class BiNormalDonnellyDist
extends BiNormalDist {
    private static final double TWOPI = Math.PI * 2;
    private static final double SQRTPI = Math.sqrt(Math.PI);
    private static final int KMAX = 6;
    private static double[] BB = new double[7];
    private static final double[] CB = new double[]{0.9999936, -0.9992989, 0.9872976, -0.9109973, 0.6829098, -0.336021, 0.07612251};

    private static double BorthT(double d, double d2) {
        int n;
        double d3 = d2 * d / 1.4142135623730951;
        double d4 = d3 * d3;
        double d5 = d3 * Math.exp(-d4);
        BiNormalDonnellyDist.BB[0] = SQRTPI * (BiNormalDonnellyDist.Gauss(1.4142135623730951 * d3) - 0.5);
        for (n = 1; n <= 6; ++n) {
            BiNormalDonnellyDist.BB[n] = ((double)(2 * n - 1) * BB[n - 1] - d5) / 2.0;
            d5 *= d4;
        }
        double d6 = d * d / 2.0;
        d5 = d / 1.4142135623730951;
        double d7 = 0.0;
        for (n = 0; n <= 6; ++n) {
            d7 += CB[n] * BB[n] / d5;
            d5 *= d6;
        }
        return d7 * Math.exp(-d6) / (Math.PI * 2);
    }

    public BiNormalDonnellyDist(double d, int n) {
        super(d);
        if (n > 15) {
            throw new IllegalArgumentException("ndig > 15");
        }
        this.decPrec = this.ndigit = n;
    }

    public BiNormalDonnellyDist(double d) {
        this(d, 15);
    }

    public BiNormalDonnellyDist(double d, double d2, double d3, double d4, double d5, int n) {
        super(d, d2, d3, d4, d5);
        if (n > 15) {
            throw new IllegalArgumentException("ndig > 15");
        }
        this.decPrec = this.ndigit = n;
    }

    public BiNormalDonnellyDist(double d, double d2, double d3, double d4, double d5) {
        this(d, d2, d3, d4, d5, 15);
    }

    public static double cdf(double d, double d2, double d3, int n) {
        double d4;
        double d5;
        if (n > 15) {
            throw new IllegalArgumentException("ndig > 15");
        }
        double d6 = BiNormalDonnellyDist.specialCDF(d, d2, d3, 13.0);
        if (d6 >= 0.0) {
            return d6;
        }
        d6 = 0.0;
        boolean bl = n <= 7;
        double d7 = d3;
        double d8 = -d;
        double d9 = -d2;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        int n2 = -1;
        if (bl) {
            d5 = BiNormalDonnellyDist.Gauss(d) / 2.0;
            d4 = BiNormalDonnellyDist.Gauss(d2) / 2.0;
        } else {
            d5 = NormalDist.cdf01(d) / 2.0;
            d4 = NormalDist.cdf01(d2) / 2.0;
        }
        boolean bl2 = true;
        double d13 = (1.0 - d7) * (1.0 + d7);
        if (d13 < 0.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double d14 = Math.sqrt(d13);
        double d15 = Math.PI * Num.TEN_NEG_POW[n];
        double d16 = 0.5 * Num.TEN_NEG_POW[n];
        if (d8 != 0.0) {
            d6 = d5;
            if (d8 * d9 < 0.0) {
                d6 -= 0.5;
            } else if (d8 * d9 == 0.0) {
                bl2 = false;
            }
        } else if (d9 == 0.0) {
            return Math.asin(d7) / (Math.PI * 2) + 0.25;
        }
        if (bl2) {
            d6 += d4;
        }
        if (d8 != 0.0) {
            bl2 = false;
            d11 = -d8;
            d12 = (d9 / d8 - d7) / d14;
            d10 = 2.0 * d5;
            n2 = -1;
        }
        do {
            if (bl2) {
                d11 = -d9;
                d12 = (d8 / d9 - d7) / d14;
                d10 = 2.0 * d4;
                n2 = 1;
            }
            bl2 = true;
            double d17 = -1.0;
            double d18 = 0.0;
            if (d12 != 0.0) {
                double d19;
                if (Math.abs(d12) >= 1.0) {
                    if (Math.abs(d12) == 1.0) {
                        d18 = d12 * d10 * (1.0 - d10) / 2.0;
                        d6 += d17 * d18;
                        if (n2 < 0) continue;
                        break;
                    }
                    d17 = -d17;
                    double d20 = bl ? BiNormalDonnellyDist.Gauss(d11) : NormalDist.cdf01(d11 *= d12);
                    if ((d12 = 1.0 / d12) < 0.0) {
                        d6 += 0.5;
                    }
                    d6 = d6 - (d10 + d20) / 2.0 + d10 * d20;
                }
                double d21 = d11 * d11;
                double d22 = d12 * d12;
                double d23 = d21 * 0.5;
                double d24 = 0.0;
                if (d23 < 300.0) {
                    d24 = Math.exp(-d23);
                }
                double d25 = d23 * d24;
                double d26 = 1.0;
                double d27 = d26 - d24;
                double d28 = d26;
                double d29 = d19 = 0.0;
                double d30 = Math.abs(d15 / d12);
                while (true) {
                    double d31 = d26 * d27 / (d29 + d28);
                    d19 += d31;
                    if (Math.abs(d31) <= d30) break;
                    d29 = d28;
                    d27 -= d25;
                    d25 *= d23 / (d28 += 1.0);
                    d26 = -d26 * d22;
                }
                d18 = (Math.atan(d12) - d12 * d19) / (Math.PI * 2);
                d6 += d17 * d18;
            }
            if (n2 >= 0) break;
        } while (d9 != 0.0);
        if (d6 < d16) {
            d6 = 0.0;
        }
        if (d6 > 1.0) {
            d6 = 1.0;
        }
        return d6;
    }

    public static double cdf(double d, double d2, double d3, double d4, double d5, double d6, double d7, int n) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (d5 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        double d8 = (d3 - d) / d2;
        double d9 = (d6 - d4) / d5;
        return BiNormalDonnellyDist.cdf(d8, d9, d7, n);
    }

    public static double barF(double d, double d2, double d3, double d4, double d5, double d6, double d7, int n) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (d5 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        double d8 = (d3 - d) / d2;
        double d9 = (d6 - d4) / d5;
        return BiNormalDonnellyDist.barF(d8, d9, d7, n);
    }

    public static double barF(double d, double d2, double d3, int n) {
        return BiNormalDonnellyDist.cdf(-d, -d2, d3, n);
    }

    public double cdf(double d, double d2) {
        return BiNormalDonnellyDist.cdf((d - this.mu1) / this.sigma1, (d2 - this.mu2) / this.sigma2, this.rho, this.ndigit);
    }

    public static double cdf(double d, double d2, double d3) {
        return BiNormalDonnellyDist.cdf(d, d2, d3, 15);
    }

    public static double cdf(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return BiNormalDonnellyDist.cdf(d, d2, d3, d4, d5, d6, d7, 15);
    }

    public double barF(double d, double d2) {
        return BiNormalDonnellyDist.barF((d - this.mu1) / this.sigma1, (d2 - this.mu2) / this.sigma2, this.rho, this.ndigit);
    }

    public static double barF(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return BiNormalDonnellyDist.barF(d, d2, d3, d4, d5, d6, d7, 15);
    }

    public static double barF(double d, double d2, double d3) {
        return BiNormalDonnellyDist.barF(d, d2, d3, 15);
    }
}

