/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BetaSymmetricalDist;
import umontreal.iro.lecuyer.randvar.BetaSymmetricalGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BetaSymmetricalBestGen
extends BetaSymmetricalGen {
    private RandomStream stream2;
    private RandomStream stream3;
    private double afactor;
    private static final double TWOPI = Math.PI * 2;

    public BetaSymmetricalBestGen(RandomStream randomStream, RandomStream randomStream2, RandomStream randomStream3, BetaSymmetricalDist betaSymmetricalDist) {
        super(randomStream, betaSymmetricalDist);
        this.stream2 = randomStream2;
        this.stream3 = randomStream3;
        this.afactor = 1.0 / betaSymmetricalDist.getAlpha();
    }

    public BetaSymmetricalBestGen(RandomStream randomStream, BetaSymmetricalDist betaSymmetricalDist) {
        this(randomStream, randomStream, randomStream, betaSymmetricalDist);
    }

    public static double nextDouble(RandomStream randomStream, RandomStream randomStream2, RandomStream randomStream3, double d) {
        double d2 = Math.cos(Math.PI * 2 * randomStream2.nextDouble());
        double d3 = 1.0 / Math.pow(randomStream.nextDouble(), 1.0 / d) - 1.0;
        double d4 = Math.sqrt(1.0 + 1.0 / (d3 * d2 * d2));
        double d5 = randomStream3.nextDouble();
        if (d5 < 0.5) {
            return 0.5 - 0.5 / d4;
        }
        return 0.5 + 0.5 / d4;
    }

    public static double nextDouble(RandomStream randomStream, double d) {
        return BetaSymmetricalBestGen.nextDouble(randomStream, randomStream, randomStream, d);
    }

    public double nextDouble() {
        double d = Math.cos(Math.PI * 2 * this.stream2.nextDouble());
        double d2 = 1.0 / Math.pow(this.stream.nextDouble(), this.afactor) - 1.0;
        double d3 = Math.sqrt(1.0 + 1.0 / (d2 * d * d));
        double d4 = this.stream3.nextDouble();
        if (d4 < 0.5) {
            return 0.5 - 0.5 / d3;
        }
        return 0.5 + 0.5 / d3;
    }

    public RandomStream getStream2() {
        return this.stream2;
    }

    public RandomStream getStream3() {
        return this.stream3;
    }
}

