/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.FileInputStream;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.coref.CorefSample;
import opennlp.tools.coref.CorefSampleDataStream;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ParagraphStream;
import opennlp.tools.util.PlainTextByLineStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorefSampleStreamFactory
extends AbstractSampleStreamFactory<CorefSample> {
    protected CorefSampleStreamFactory() {
        super(Parameters.class);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(CorefSample.class, "opennlp", new CorefSampleStreamFactory());
    }

    @Override
    public ObjectStream<CorefSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        CmdLineUtil.checkInputFile("Data", params.getData());
        FileInputStream sampleDataIn = CmdLineUtil.openInFile(params.getData());
        ParagraphStream lineStream = new ParagraphStream(new PlainTextByLineStream(sampleDataIn.getChannel(), params.getEncoding()));
        return new CorefSampleDataStream(lineStream);
    }

    static interface Parameters
    extends BasicFormatParams {
    }
}

