/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j;

import java.util.ArrayList;
import java.util.List;
import org.semver4j.Range;
import org.semver4j.RangesList;
import org.semver4j.Semver;

public class RangesExpression {
    private final RangesList rangesList = new RangesList();
    private final List<Range> andOperationRanges = new ArrayList<Range>();

    public static RangesExpression equal(String version) {
        return RangesExpression.equal(new Semver(version));
    }

    public static RangesExpression equal(Semver version) {
        return new RangesExpression(new Range(version, Range.RangeOperator.EQ));
    }

    public static RangesExpression greater(String version) {
        return RangesExpression.greater(new Semver(version));
    }

    public static RangesExpression greater(Semver version) {
        return new RangesExpression(new Range(version, Range.RangeOperator.GT));
    }

    public static RangesExpression greaterOrEqual(String version) {
        return RangesExpression.greaterOrEqual(new Semver(version));
    }

    public static RangesExpression greaterOrEqual(Semver version) {
        return new RangesExpression(new Range(version, Range.RangeOperator.GTE));
    }

    public static RangesExpression less(String version) {
        return RangesExpression.less(new Semver(version));
    }

    public static RangesExpression less(Semver version) {
        return new RangesExpression(new Range(version, Range.RangeOperator.LT));
    }

    public static RangesExpression lessOrEqual(String version) {
        return RangesExpression.lessOrEqual(new Semver(version));
    }

    public static RangesExpression lessOrEqual(Semver version) {
        return new RangesExpression(new Range(version, Range.RangeOperator.LTE));
    }

    RangesExpression(Range range) {
        this.andOperationRanges.add(range);
    }

    public RangesExpression and(RangesExpression rangeExpression) {
        RangesList rangesList = rangeExpression.get();
        List<List<Range>> lists = rangesList.get();
        for (List<Range> list : lists) {
            this.andOperationRanges.addAll(list);
            if (lists.size() <= 1) continue;
            this.flushAndClearAndOperationRangesToRangesList();
        }
        return this;
    }

    public RangesExpression or(RangesExpression rangeExpression) {
        this.flushAndClearAndOperationRangesToRangesList();
        return this.and(rangeExpression);
    }

    RangesList get() {
        if (!this.andOperationRanges.isEmpty()) {
            this.flushAndClearAndOperationRangesToRangesList();
        }
        return this.rangesList;
    }

    private void flushAndClearAndOperationRangesToRangesList() {
        this.rangesList.add(new ArrayList<Range>(this.andOperationRanges));
        this.andOperationRanges.clear();
    }
}

