/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.MatrixAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

public class MultlineAtom
extends Atom {
    public static SpaceAtom vsep_in = new SpaceAtom(1, 0.0f, 1.0f, 0.0f);
    public static final int MULTLINE = 0;
    public static final int GATHER = 1;
    public static final int GATHERED = 2;
    private ArrayOfAtoms column;
    private int type;
    private boolean isPartial;

    public MultlineAtom(boolean isPartial, ArrayOfAtoms column, int type) {
        this.isPartial = isPartial;
        this.column = column;
        this.type = type;
    }

    public MultlineAtom(ArrayOfAtoms column, int type) {
        this(false, column, type);
    }

    public Box createBox(TeXEnvironment env) {
        int alignment;
        float tw = env.getTextwidth();
        if (tw == Float.POSITIVE_INFINITY || this.type == 2) {
            return new MatrixAtom(this.isPartial, this.column, "").createBox(env);
        }
        VerticalBox vb = new VerticalBox();
        Atom at = this.column.array.get(0).get(0);
        int n = alignment = this.type == 1 ? 2 : 0;
        if (at.alignment != -1) {
            alignment = at.alignment;
        }
        vb.add(new HorizontalBox(at.createBox(env), tw, alignment));
        Box Vsep = vsep_in.createBox(env);
        for (int i = 1; i < this.column.row - 1; ++i) {
            at = this.column.array.get(i).get(0);
            alignment = 2;
            if (at.alignment != -1) {
                alignment = at.alignment;
            }
            vb.add(Vsep);
            vb.add(new HorizontalBox(at.createBox(env), tw, alignment));
        }
        if (this.column.row > 1) {
            at = this.column.array.get(this.column.row - 1).get(0);
            int n2 = alignment = this.type == 1 ? 2 : 1;
            if (at.alignment != -1) {
                alignment = at.alignment;
            }
            vb.add(Vsep);
            vb.add(new HorizontalBox(at.createBox(env), tw, alignment));
        }
        float height = vb.getHeight() + vb.getDepth();
        vb.setHeight(height / 2.0f);
        vb.setDepth(height / 2.0f);
        return vb;
    }
}

