/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.PrefDialog;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JGR.util.TableSorter;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.Dependent;
import org.rosuda.ibase.Loader;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarDouble;
import org.rosuda.ibase.SVarFact;
import org.rosuda.ibase.SVarInt;
import org.rosuda.ibase.SVarObj;
import org.rosuda.ibase.SVarSet;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;

public class DataTable
extends TJFrame
implements ActionListener,
MouseListener,
KeyListener {
    private static final long serialVersionUID = 4257267810053816420L;
    private static final int[] searchIndex = new int[]{-1, -1};
    private static int selectedColumn = -1;
    private static String searchString = "";
    private final GridBagLayout layout = new GridBagLayout();
    private final JScrollPane scrollArea = new JScrollPane();
    private final JTable dataTable;
    private final JTableHeader tableHeader;
    private final JButton save = new JButton();
    private final DataTableCellEditor cell = new DataTableCellEditor();
    private SVarSet vs;
    private DataTableModel tabModel;
    private DataTableColumnModel columnModel;
    private TableSorter sorter;
    private String fileName = null;
    private boolean modified = false;
    private String type = "data.frame";
    private boolean editable = true;
    private boolean rownames = false;

    public DataTable() {
        this(null, null, true);
    }

    public DataTable(SVarSet vs, String type, boolean editable) {
        this(vs, type, editable, true);
    }

    public DataTable(SVarSet vs, String type, boolean editable, boolean visible) {
        super("DataTable Editor", false, 153);
        if (vs == null) {
            vs = new SVarSet();
            vs.setName("NewDataTable");
            this.save.setText("Save");
            this.save.setToolTipText("Save");
            this.save.setActionCommand("saveData");
        } else {
            this.save.setText("Update");
            this.save.setToolTipText("Update");
            this.save.setActionCommand("export");
            this.setTitle("DataTable - " + vs.getName().replaceFirst("jgr_temp", ""));
            if (type != null) {
                this.type = type;
            }
        }
        this.vs = vs;
        this.editable = editable;
        this.save.setEnabled(editable);
        String[] myMenu = new String[]{"+", "File", "@OOpen", "loadData", "@SSave", "saveData", "!SSave as", "saveDataAs", "Export to R", "export", "~File.Basic.End", "+", "Edit", "@XCut", "cut", "@CCopy", "copy", "@VPaste", "paste", "Delete", "delete", "@ASelect All", "selAll", "-", "@FFind", "search", "@GFind Next", "searchnext", "+", "Tools", "Add Column", "addCol", "Remove Column", "rmCol", "Add Row", "addRow", "Remove Row", "rmRow", "-", "-", "Goto Case", "gotoCase", "~Window", "+", "Help", "R Help", "rhelp", "~Preferences", "~About", "0"};
        EzMenuSwing.getEzMenu(this, this, myMenu);
        this.dataTable = new JTable(){

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                boolean result = super.editCellAt(row, column, e);
                final Component editor = this.getEditorComponent();
                if (editor != null && editor instanceof JTextComponent) {
                    if (e == null || e.getClass().toString().endsWith("KeyEvent")) {
                        ((JTextComponent)editor).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)editor).selectAll();
                            }
                        });
                    }
                }
                return result;
            }
        };
        this.tableHeader = this.dataTable.getTableHeader();
        if (FontTracker.current == null) {
            FontTracker.current = new FontTracker();
        }
        FontTracker.current.add(this.dataTable);
        this.save.addActionListener(this);
        this.dataTable.setAutoResizeMode(0);
        this.columnModel = new DataTableColumnModel(this);
        this.dataTable.setFont(JGRPrefs.DefaultFont);
        this.dataTable.setColumnModel(this.columnModel);
        this.tabModel = new DataTableModel(this);
        this.sorter = new TableSorter(this.tabModel);
        this.dataTable.setModel(this.sorter);
        this.sorter.setTableHeader(this.tableHeader);
        this.dataTable.setDefaultRenderer(Object.class, new DataTableCellRenderer());
        this.dataTable.setShowGrid(true);
        this.dataTable.setRowHeight((int)((double)JGRPrefs.FontSize * 1.6));
        this.dataTable.setColumnSelectionAllowed(true);
        this.dataTable.setRowSelectionAllowed(true);
        this.dataTable.setCellSelectionEnabled(true);
        this.dataTable.addMouseListener(this);
        this.dataTable.addKeyListener(this);
        this.tableHeader.addMouseListener(this);
        this.cell.getComponent().addMouseListener(this);
        this.cell.getComponent().addKeyListener(this);
        this.scrollArea.setWheelScrollingEnabled(true);
        this.scrollArea.getViewport().add(this.dataTable);
        this.getContentPane().setLayout(this.layout);
        this.getContentPane().add((Component)new JScrollPane(this.dataTable), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.getContentPane().add((Component)this.save, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 5, 10), 0, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DataTable.this.exit();
            }
        });
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.setLocation(this.getLocation().x, 10);
        int h = this.dataTable.getRowHeight();
        int rc = this.dataTable.getRowCount();
        int cc = this.dataTable.getColumnCount();
        int width = cc * 75;
        int height = (int)((double)(rc * h) * 1.6);
        Dimension d = new Dimension(width < 400 && cc < 2 ? 400 : width, height < 400 && rc < 11 ? 300 : height);
        this.setSize(new Dimension(d.width > Common.screenRes.width ? Common.screenRes.width - 50 : d.width, d.height > Common.screenRes.height ? Common.screenRes.height - 50 : d.height));
        this.setLocation(this.getLocation().x + 100, 10);
        this.initPlacement();
        if (visible) {
            this.setVisible(true);
        }
    }

    private void addColumn() {
        this.modified = true;
        String[] val = new NewColumnDialog(this).showInputDialog();
        String[] varType = new String[]{"Numeric (double)", "Numeric (integer)", "Factor", "Character"};
        if (val != null) {
            SVar v;
            if (val[1].equals(varType[0])) {
                v = new SVarDouble(null, this.dataTable.getRowCount());
            } else if (val[1].equals(varType[1])) {
                v = new SVarInt(null, this.dataTable.getRowCount());
            } else if (val[1].equals(varType[3])) {
                v = new SVarObj(null, false);
                v.setAllEmpty(this.dataTable.getRowCount());
            } else {
                v = new SVarFact(null, this.dataTable.getRowCount());
            }
            if (val[0].equals("")) {
                this.vs.insert(selectedColumn < 1 ? this.tabModel.cols - 1 : selectedColumn, v);
            } else {
                this.vs.insert(val[0], selectedColumn < 1 ? this.tabModel.cols - 1 : selectedColumn, v);
            }
            this.refresh();
        }
    }

    private void addRow() {
        this.modified = true;
        int selectedRow = this.currentRow();
        selectedRow = selectedRow == -1 ? this.tabModel.rows - 1 : selectedRow;
        this.vs.insertCaseAt(selectedRow + 1);
        this.refresh();
    }

    public int currentCol() {
        return this.dataTable.getSelectedColumn();
    }

    public int currentCol(MouseEvent e) {
        if (e.getSource().equals(this.tableHeader)) {
            return this.tableHeader.columnAtPoint(e.getPoint());
        }
        return this.dataTable.getSelectedColumn() == -1 ? this.tableHeader.columnAtPoint(e.getPoint()) : this.dataTable.getSelectedColumn();
    }

    public int[] currentCols() {
        return this.dataTable.getSelectedColumns();
    }

    public int currentRow() {
        return this.dataTable.getSelectedRow();
    }

    public int[] currentRows() {
        return this.dataTable.getSelectedRows();
    }

    private void deleteContent(int[] cols, int[] rows) {
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i] == 0) continue;
            for (int z = 0; z < rows.length; ++z) {
                this.vs.at(cols[i] - 1).replace(rows[z], null);
            }
        }
        this.refresh();
    }

    public void exit() {
        if (this.modified && this.editable) {
            if (this.save.getText() == "Save") {
                int i = JOptionPane.showConfirmDialog(this, "Save data?", "Exit", 1, 3);
                if (i == 1) {
                    super.dispose();
                } else if (i == 0 && this.saveData()) {
                    super.dispose();
                }
            } else {
                this.export(true);
            }
        } else {
            super.dispose();
        }
    }

    private void find(int x, int y) {
        if (searchString == "" || y == -1) {
            searchString = JOptionPane.showInputDialog(new JTextField(), "Search:", "Search for:", -1);
        }
        if (searchString != null) {
            int[] f_index = this.vs.whereis(searchString, x == -1 ? 0 : x, y == -1 ? 0 : y);
            if (f_index[0] == -1 && f_index[1] == -1) {
                JOptionPane.showMessageDialog(this, "Not found", "Result", 2);
            } else {
                f_index[1] = this.sorter.modelIndex(f_index[1]);
                this.gotoCell(f_index[0] + 1, f_index[1]);
            }
            DataTable.searchIndex[0] = f_index[0];
            if (f_index[0] + 1 == this.tabModel.cols - 1) {
                DataTable.searchIndex[0] = -1;
                DataTable.searchIndex[1] = f_index[1] + 1;
            } else {
                DataTable.searchIndex[0] = f_index[0] + 1;
                DataTable.searchIndex[1] = f_index[1];
            }
        }
    }

    private void gotoCase(int c) {
        String val = null;
        JScrollBar vscroll = this.scrollArea.getVerticalScrollBar();
        int rowHeight = this.dataTable.getRowHeight();
        if (c == -1) {
            val = JOptionPane.showInputDialog(new JTextField(), "Goto Case:", "Goto Case", -1);
        }
        if (val != null) {
            try {
                int Case = c == -1 ? Integer.parseInt(val) - 1 : c;
                this.dataTable.setRowSelectionInterval(Case, Case);
                this.dataTable.setColumnSelectionInterval(0, this.tabModel.cols - 1);
                vscroll.setValue(Case * rowHeight - vscroll.getVisibleAmount() + 10 < 0 ? 0 : Case * rowHeight - vscroll.getVisibleAmount() + rowHeight + 10);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private void gotoCell(int col, int row) {
        int rowHeight = this.dataTable.getRowHeight();
        this.dataTable.setRowSelectionInterval(row, row);
        JScrollBar vscroll = this.scrollArea.getVerticalScrollBar();
        vscroll.setValue(row * rowHeight - vscroll.getVisibleAmount() + 10 < 0 ? 0 : row * rowHeight - vscroll.getVisibleAmount() + rowHeight + 10);
        this.dataTable.setColumnSelectionInterval(col, col);
        JScrollBar hscroll = this.scrollArea.getHorizontalScrollBar();
        hscroll.setValue(col * 75 - hscroll.getVisibleAmount() + 30 < 0 ? 0 : col * 75 - hscroll.getVisibleAmount() + 75 + 10);
    }

    public JTable getJTable() {
        return this.dataTable;
    }

    private void loadData() {
        FileSelector fopen = new FileSelector(this, "Open...", 0, JGRPrefs.workingDirectory);
        fopen.setVisible(true);
        if (fopen.getFile() != null) {
            this.setWorking(true);
            JGRPrefs.workingDirectory = fopen.getDirectory();
            this.fileName = JGRPrefs.workingDirectory + fopen.getFile();
            try {
                this.vs = new SVarSet();
                BufferedReader br = new BufferedReader(new FileReader(this.fileName));
                Loader.LoadTSV(br, this.vs, true);
                br.close();
                this.vs.setMarker(new SMarker(this.vs.at(0).size()));
                this.vs.setName(this.fileName);
                this.setTitle("DataTable - " + this.vs.getName());
                this.refresh();
                this.dataTable.setModel(this.sorter);
            }
            catch (Exception e) {
                new ErrorMsg(e);
            }
            this.setWorking(false);
        }
    }

    private void moveColumnsSVar(int from, int to) {
        this.vs.move(from - 1, to - 1);
        this.refresh();
    }

    private void refresh() {
        int direction = this.sorter.getSortingStatus();
        int col = this.sorter.getSortedColumn();
        this.tabModel = new DataTableModel(this);
        this.sorter = new TableSorter(this.tabModel);
        this.dataTable.setModel(this.sorter);
        this.sorter.setTableHeader(this.tableHeader);
        this.sorter.setSortingStatus(col, direction);
    }

    private void renameColumn(int index) {
        String old_name = this.vs.at(index - 1).getName();
        String val = (String)JOptionPane.showInputDialog(new JTextField(), "Rename Column into:", "Rename Column", -1, null, null, old_name);
        if (val != null) {
            this.vs.at(index - 1).setName(val);
            this.refresh();
        }
    }

    private void removeColumns() {
        int[] selectedColumns = this.currentCols();
        if (selectedColumns.length == 0) {
            selectedColumns = new int[]{selectedColumn};
            if (this.dataTable.getColumnName(selectedColumn).equals("row.names")) {
                return;
            }
        }
        for (int i = 0; i < selectedColumns.length; ++i) {
            if (selectedColumns[i] <= 0) continue;
            this.vs.remove(selectedColumns[i] - 1 - i);
        }
        this.refresh();
    }

    private void removeRows() {
        int[] selectedRows = this.currentRows();
        for (int i = selectedRows.length; i > 0; --i) {
            this.vs.removeCaseAt(this.sorter.modelIndex(selectedRows[i - 1]));
        }
        this.refresh();
    }

    private void export(boolean quit) {
        JTextField name = new JTextField(this.vs.getName());
        name.setMinimumSize(new Dimension(150, 20));
        name.setPreferredSize(new Dimension(150, 20));
        name.setMaximumSize(new Dimension(150, 20));
        JPanel ex = new JPanel(new BorderLayout());
        ex.add((Component)new JLabel("Export as: "), "Center");
        ex.add((Component)name, "South");
        int op = JOptionPane.showOptionDialog(this, ex, "Export to R?", 1, 3, null, null, this.vs.getName());
        String objname = name.getText();
        if (op == 2) {
            return;
        }
        if (op == 1 && objname != null && quit) {
            super.dispose();
        } else if (op == 0 && objname != null && objname.trim().length() > 0) {
            this.vs.setName(objname.trim());
            boolean b = RController.export(this.vs, this.type);
            if (quit) {
                if (b) {
                    super.dispose();
                } else if (JOptionPane.showConfirmDialog(this, "Export to R is not supported\nExit Anyway?", "Export Error", 0, 0) == 0) {
                    this.dispose();
                }
            } else if (!b) {
                JOptionPane.showMessageDialog(this, "Export to R is not supported", "Export Error", 0);
            }
        }
        this.modified = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveData() {
        if (this.fileName == null || this.fileName.equals("")) {
            return this.saveDataAs();
        }
        this.setWorking(true);
        BufferedWriter out = null;
        String s = "";
        try {
            out = new BufferedWriter(new FileWriter(this.fileName));
            int cols = this.vs.count();
            for (int k = 0; k < cols - 1; ++k) {
                if (this.vs.at(k).getName().equals("row.names")) {
                    out.write(" ");
                    continue;
                }
                out.write("" + this.vs.at(k).getName() + "\t");
            }
            out.write("" + this.vs.at(cols - 1).getName() + "\n");
            out.flush();
            for (int i = 0; i < this.vs.length(); ++i) {
                for (int z = 0; z < cols - 1; ++z) {
                    s = this.vs.at(z).at(i) == null ? " " : this.vs.at(z).at(i).toString();
                    out.write("" + s + "\t");
                }
                s = this.vs.at(cols - 1).at(i) == null ? " " : this.vs.at(cols - 1).at(i).toString();
                out.write("" + s + "\n");
                out.flush();
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
        finally {
            this.setWorking(false);
            this.modified = false;
        }
        return true;
    }

    private boolean saveDataAs() {
        FileSelector fsave = new FileSelector(this, "Save as...", 1, JGRPrefs.workingDirectory);
        fsave.setVisible(true);
        if (fsave.getFile() != null) {
            JGRPrefs.workingDirectory = fsave.getDirectory();
            this.fileName = JGRPrefs.workingDirectory + fsave.getFile();
            return this.saveData();
        }
        return false;
    }

    private void popUpMenu(MouseEvent e) {
        JPopupMenu tabMenue = new JPopupMenu();
        JMenuItem renameColItem = new JMenuItem();
        JMenuItem addColItem = new JMenuItem();
        JMenuItem rmColItem = new JMenuItem();
        JMenuItem addRowItem = new JMenuItem();
        JMenuItem rmRowItem = new JMenuItem();
        JMenuItem pasteItem = new JMenuItem();
        JMenuItem titleItem = new JMenuItem();
        JMenuItem copyItem = new JMenuItem();
        JMenuItem cutItem = new JMenuItem();
        renameColItem.setToolTipText("Rename Column");
        renameColItem.setActionCommand("renameCol");
        renameColItem.setText("Rename Column");
        renameColItem.addActionListener(this);
        addColItem.setToolTipText("Insert Column");
        addColItem.setActionCommand("addCol");
        addColItem.setText("Insert Column");
        addColItem.addActionListener(this);
        rmColItem.setToolTipText("Remove Column");
        rmColItem.setActionCommand("rmCol");
        rmColItem.setText("Remove Column");
        rmColItem.addActionListener(this);
        addRowItem.setToolTipText("Insert Row");
        addRowItem.setActionCommand("addRow");
        addRowItem.setText("Insert Row");
        addRowItem.addActionListener(this);
        rmRowItem.setActionCommand("rmRow");
        rmRowItem.setText("Remove Row");
        rmRowItem.setToolTipText("Remove Row");
        rmRowItem.addActionListener(this);
        cutItem.setToolTipText("Cut");
        cutItem.setActionCommand("cut");
        cutItem.setText("Cut");
        cutItem.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        cutItem.addActionListener(this);
        copyItem.setToolTipText("Copy");
        copyItem.setActionCommand("copy");
        copyItem.setText("Copy");
        copyItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        copyItem.addActionListener(this);
        pasteItem.setToolTipText("Paste");
        pasteItem.setActionCommand("paste");
        pasteItem.setText("Paste");
        pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        pasteItem.addActionListener(this);
        titleItem.setEnabled(false);
        tabMenue.add(titleItem);
        tabMenue.addSeparator();
        tabMenue.add(cutItem);
        tabMenue.add(copyItem);
        tabMenue.add(pasteItem);
        tabMenue.addSeparator();
        tabMenue.add(renameColItem);
        tabMenue.addSeparator();
        tabMenue.add(addColItem);
        tabMenue.add(rmColItem);
        tabMenue.addSeparator();
        tabMenue.add(addRowItem);
        tabMenue.add(rmRowItem);
        if (!e.getSource().equals(this.cell.getComponent())) {
            cutItem.setEnabled(false);
            copyItem.setEnabled(false);
            pasteItem.setEnabled(false);
            if (e.getSource().equals(this.tableHeader)) {
                renameColItem.setEnabled(true);
                addColItem.setEnabled(true);
                rmColItem.setEnabled(true);
                if (this.currentCol(e) == 0) {
                    addRowItem.setEnabled(true);
                    rmRowItem.setEnabled(true);
                } else {
                    addRowItem.setEnabled(false);
                    rmRowItem.setEnabled(false);
                }
            } else {
                if (this.dataTable.getSelectedRowCount() == this.tabModel.rows) {
                    renameColItem.setEnabled(true);
                    addColItem.setEnabled(true);
                    rmColItem.setEnabled(true);
                } else {
                    renameColItem.setEnabled(false);
                    addColItem.setEnabled(false);
                    rmColItem.setEnabled(false);
                }
                if (this.currentCol(e) == 0) {
                    addRowItem.setEnabled(true);
                    rmRowItem.setEnabled(true);
                } else {
                    addRowItem.setEnabled(false);
                    rmRowItem.setEnabled(false);
                }
            }
        } else {
            cutItem.setEnabled(true);
            copyItem.setEnabled(true);
            pasteItem.setEnabled(true);
            renameColItem.setEnabled(false);
            addColItem.setEnabled(false);
            rmColItem.setEnabled(false);
            addRowItem.setEnabled(false);
            rmRowItem.setEnabled(false);
        }
        tabMenue.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String cmd = e.getActionCommand();
            if (cmd == "about") {
                new AboutDialog(this);
            } else if (cmd == "addCol") {
                this.addColumn();
            } else if (cmd == "addRow") {
                this.addRow();
            } else if (cmd == "cut") {
                ((JTextComponent)this.cell.getComponent()).cut();
            } else if (cmd == "copy") {
                ((JTextComponent)this.cell.getComponent()).copy();
            } else if (cmd == "delete") {
                this.deleteContent(this.dataTable.getSelectedColumns(), this.dataTable.getSelectedRows());
            } else if (cmd == "exit") {
                this.exit();
            } else if (cmd == "export") {
                this.export(false);
            } else if (cmd == "search") {
                this.find(-1, -1);
            } else if (cmd == "searchnext") {
                this.find(searchIndex[0], searchIndex[1]);
            } else if (cmd == "gotoCase") {
                this.gotoCase(-1);
            } else if (cmd == "loadData") {
                this.loadData();
            } else if (cmd == "help") {
                JGR.MAINRCONSOLE.execute("help.start()", false);
            } else if (cmd == "paste") {
                ((JTextComponent)this.cell.getComponent()).paste();
            } else if (cmd == "renameCol" && selectedColumn > 0) {
                this.renameColumn(selectedColumn);
            } else if (cmd == "rmCol") {
                this.removeColumns();
            } else if (cmd == "rmRow") {
                this.removeRows();
            } else if (cmd == "saveData") {
                this.saveData();
            } else if (cmd == "saveDataAs") {
                this.saveDataAs();
            } else if (cmd == "selAll") {
                this.dataTable.selectAll();
            } else if (cmd == "preferences") {
                PrefDialog.showPreferences(this);
            }
        }
        catch (Exception ex) {
            new ErrorMsg(ex);
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 127 && (this.dataTable.getSelectedColumnCount() > 1 || this.dataTable.getSelectedRowCount() > 1)) {
            this.deleteContent(this.dataTable.getSelectedColumns(), this.dataTable.getSelectedRows());
        } else if (ke.getKeyCode() == 114) {
            this.find(searchIndex[0], searchIndex[1]);
        } else if (ke.getKeyCode() == 10 && this.dataTable.getSelectedRow() == this.tabModel.rows - 1 && this.dataTable.getSelectedColumn() == this.tabModel.cols - 1) {
            if (this.editable && this.dataTable.isEditing()) {
                this.tabModel.setValueAt(((JTextComponent)this.cell.getComponent()).getText(), this.dataTable.getSelectedRow(), this.dataTable.getSelectedColumn());
            }
            this.addRow();
            this.tabModel.fireTableStructureChanged();
        } else if (this.editable && ke.getKeyCode() == 9 && this.dataTable.getSelectedRow() == 0 && this.dataTable.getSelectedColumn() == this.tabModel.cols - 1 && !ke.isShiftDown()) {
            if (this.dataTable.isEditing()) {
                this.tabModel.setValueAt(((JTextComponent)this.cell.getComponent()).getText(), this.dataTable.getSelectedRow(), this.dataTable.getSelectedColumn());
            }
            selectedColumn = -1;
            this.addColumn();
            this.tabModel.fireTableStructureChanged();
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.modified = this.dataTable.getSelectedColumn() > 0;
        try {
            selectedColumn = this.currentCol(e);
            if (e.getSource().equals(this.tableHeader)) {
                int i = this.dataTable.columnAtPoint(e.getPoint());
                if (i != 0 && e.isPopupTrigger()) {
                    this.popUpMenu(e);
                } else if (e.getClickCount() == 2 && selectedColumn > 0 && !this.dataTable.getColumnName(selectedColumn).equals("row.names")) {
                    this.renameColumn(selectedColumn);
                }
            } else if (e.isPopupTrigger()) {
                this.popUpMenu(e);
            } else if (selectedColumn == 0) {
                this.dataTable.setColumnSelectionInterval(0, this.tabModel.cols - 1);
            }
        }
        catch (Exception ex) {
            new ErrorMsg(ex);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        try {
            if (e.getSource().equals(this.tableHeader)) {
                String rn = this.dataTable.getColumnName(this.dataTable.columnAtPoint(e.getPoint()));
                int i = this.dataTable.columnAtPoint(e.getPoint());
                if (i != 0 && rn != "row.names" && e.isPopupTrigger()) {
                    this.popUpMenu(e);
                }
            } else if (e.isPopupTrigger()) {
                this.popUpMenu(e);
            }
            int from = this.dataTable.getColumn(this.dataTable.getColumnName(selectedColumn)).getModelIndex();
            int to = selectedColumn;
            if (from != 0 && to != 0 && (!this.rownames || from != 1 && to != 1) && from != to) {
                this.moveColumnsSVar(from, to);
            }
        }
        catch (Exception ex) {
            new ErrorMsg(ex);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class MarkerSelectionModel
    implements ListSelectionModel,
    Dependent {
        SMarker m;
        Vector ls;
        int anchor;
        int lead;
        boolean isadj = false;

        MarkerSelectionModel(SMarker mark) {
            this.m = mark;
            this.ls = new Vector();
            this.m.addDepend(this);
        }

        protected void finalize() {
            if (this.m != null) {
                this.m.delDepend(this);
            }
            this.ls.removeAllElements();
            this.m = null;
        }

        @Override
        public void Notifying(NotifyMsg msg, Object src, Vector path) {
            ListSelectionEvent lse = new ListSelectionEvent(this, 0, this.m.size(), false);
            for (int i = 0; i < this.ls.size(); ++i) {
                ((ListSelectionListener)this.ls.elementAt(i)).valueChanged(lse);
            }
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            this.m.selectNone();
            this.addSelectionInterval(index0, index1);
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            int j;
            this.anchor = index0;
            this.lead = index1;
            int i = index0 < index1 ? index0 : index1;
            int n = j = index0 < index1 ? index1 : index0;
            while (i <= j) {
                this.m.set(i++, true);
            }
            this.m.NotifyAll(new NotifyMsg(this.m, 4096));
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            int j;
            int i = index0 < index1 ? index0 : index1;
            int n = j = index0 < index1 ? index1 : index0;
            while (i <= j) {
                this.m.set(i++, false);
            }
            this.m.NotifyAll(new NotifyMsg(this.m, 4096));
        }

        @Override
        public int getMinSelectionIndex() {
            if (this.isSelectionEmpty()) {
                return -1;
            }
            int j = this.m.size();
            for (int i = 0; i < j; ++i) {
                if (!this.m.at(i)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getMaxSelectionIndex() {
            if (this.isSelectionEmpty()) {
                return -1;
            }
            for (int i = this.m.size() - 1; i >= 0; --i) {
                if (!this.m.at(i)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean isSelectedIndex(int index) {
            return this.m.at(index);
        }

        @Override
        public int getAnchorSelectionIndex() {
            return this.anchor;
        }

        @Override
        public void setAnchorSelectionIndex(int index) {
            this.anchor = index;
        }

        @Override
        public int getLeadSelectionIndex() {
            return this.lead;
        }

        @Override
        public void setLeadSelectionIndex(int index) {
            if (index == this.lead) {
                return;
            }
            if (index >= this.anchor) {
                if (this.lead < this.anchor) {
                    this.removeSelectionInterval(this.lead, this.anchor - 1);
                }
                if (index < this.lead) {
                    this.removeSelectionInterval(index + 1, this.lead);
                    this.lead = index;
                } else {
                    this.addSelectionInterval(this.anchor, index);
                }
            } else {
                if (this.lead > this.anchor) {
                    this.removeSelectionInterval(this.anchor + 1, this.lead);
                }
                if (index > this.lead) {
                    this.removeSelectionInterval(this.lead, index - 1);
                    this.lead = index;
                } else {
                    this.addSelectionInterval(this.anchor, index);
                }
            }
        }

        @Override
        public void clearSelection() {
            this.m.selectNone();
            this.m.NotifyAll(new NotifyMsg(this.m, 4096));
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.m.marked() == 0;
        }

        @Override
        public void insertIndexInterval(int index, int length, boolean before) {
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
        }

        @Override
        public boolean getValueIsAdjusting() {
            return this.isadj;
        }

        @Override
        public void setValueIsAdjusting(boolean valueIsAdjusting) {
            this.isadj = valueIsAdjusting;
        }

        @Override
        public int getSelectionMode() {
            return 2;
        }

        @Override
        public void setSelectionMode(int selectionMode) {
        }

        @Override
        public void addListSelectionListener(ListSelectionListener x) {
            this.ls.addElement(x);
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener x) {
            this.ls.removeElement(x);
        }
    }

    class NewColumnDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 176433470901874606L;
        String[] varType;
        String[] result;
        JComboBox typeChooser;
        JTextField name;
        JButton cancel;
        JButton ok;

        public NewColumnDialog(Frame f) {
            super(f, "Add Column", true);
            this.varType = new String[]{"Numeric (double)", "Numeric (integer)", "Factor", "Character"};
            this.result = null;
            this.typeChooser = new JComboBox<String>(this.varType);
            this.name = new JTextField();
            this.cancel = new JButton("Cancel");
            this.ok = new JButton("Ok");
            this.cancel.setActionCommand("cancel");
            this.ok.setActionCommand("ok");
            this.cancel.addActionListener(this);
            this.ok.addActionListener(this);
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)this.name, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 2, 5), 0, 0));
            this.getContentPane().add((Component)this.typeChooser, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 17, 1, new Insets(2, 5, 2, 5), 0, 0));
            this.getContentPane().add((Component)this.cancel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 50, 2, 5), 0, 0));
            this.getContentPane().add((Component)this.ok, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
            this.setDefaultCloseOperation(2);
            this.getRootPane().setDefaultButton(this.ok);
            this.setResizable(false);
            this.setSize(250, 120);
            this.setLocation(f.getLocation().x + (f.getWidth() / 2 - 125), f.getLocation().y + (f.getHeight() / 2 - 60));
        }

        public String[] showInputDialog() {
            this.setVisible(true);
            return this.result;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd == "cancel") {
                this.dispose();
            } else if (cmd == "ok") {
                this.result = new String[2];
                this.result[0] = this.name.getText();
                this.result[1] = this.typeChooser.getSelectedItem().toString();
                this.dispose();
            }
        }
    }

    class DataTableCellRenderer
    extends DefaultTableCellRenderer {
        private Color whiteColor = new Color(254, 254, 254);
        private Color alternateColor = new Color(237, 243, 254);
        private Color selectedColor = new Color(61, 128, 223);

        DataTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            Color bg = !selected ? (row % 2 == 0 ? this.alternateColor : this.whiteColor) : this.selectedColor;
            this.setBackground(bg);
            Color fg = selected ? Color.white : Color.black;
            this.setForeground(fg);
            return this;
        }
    }

    class DataTableCellDocument
    extends PlainDocument {
        private static final long serialVersionUID = 3679382895962869038L;

        DataTableCellDocument() {
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            try {
                if (DataTable.this.vs.at(DataTable.this.dataTable.getSelectedColumn() - 1).isNum() && !str.matches("[+|-]*[[0-9]+.[0-9]+]*[0-9]*")) {
                    str = "";
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (Exception e) {
                new ErrorMsg(e);
            }
            super.insertString(offset, str, a);
        }
    }

    class DataTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -4264723305967926901L;
        JTextField component;

        DataTableCellEditor() {
            this.component = new JTextField(new DataTableCellDocument(), null, 1);
        }

        public Component getComponent() {
            return this.component;
        }

        @Override
        public Component getTableCellEditorComponent(JTable t, Object v, boolean b, int r, int c) {
            DataTable.this.dataTable.setColumnSelectionInterval(c, c);
            this.component.setText(v.toString().equals("NA") ? "" : v.toString());
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return this.component.getText();
        }
    }

    class DataTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 6682943116161132225L;
        DataTable tab;
        int cols;
        int rows;

        DataTableModel(DataTable tab) {
            this.tab = tab;
            if (tab.vs == null || tab.vs.count() == 0) {
                this.cols = 1;
                this.rows = 1;
            } else {
                this.cols = DataTable.this.vs.count() + 1;
                this.rows = DataTable.this.vs.at(0).size();
            }
        }

        @Override
        public int getColumnCount() {
            return this.cols;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object value = null;
            if (col == 0) {
                value = new Integer(row + 1);
            } else if (DataTable.this.vs != null) {
                try {
                    value = this.tab.vs.at(col - 1).at(row);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return value == null ? "NA" : value;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            try {
                if (value.toString().equals("") || value.toString().equals("NA")) {
                    value = null;
                }
                if (DataTable.this.vs.at(col - 1).isNum()) {
                    if (value != null) {
                        if (value.toString().indexOf(".") != -1) {
                            this.tab.vs.at(col - 1).replace(row, Double.parseDouble(value.toString()));
                        } else {
                            this.tab.vs.at(col - 1).replace(row, Integer.parseInt(value.toString()));
                        }
                    } else if (this.tab.vs.at(col - 1).getClass().getName().equals("org.rosuda.ibase.SVarDouble")) {
                        this.tab.vs.at(col - 1).replace(row, SVar.double_NA);
                    } else if (this.tab.vs.at(col - 1).getClass().getName().equals("org.rosuda.ibase.SVarInt")) {
                        this.tab.vs.at(col - 1).replace(row, SVar.int_NA);
                    } else {
                        this.tab.vs.at(col - 1).replace(row, Double.NaN);
                    }
                } else if (this.tab.vs.at(col - 1).getClass().getName().equals("org.rosuda.ibase.SVarFact")) {
                    this.tab.vs.at(col - 1).replace(row, value == null ? "NA" : value);
                } else {
                    this.tab.vs.at(col - 1).replace(row, value);
                }
            }
            catch (Exception e) {
                new ErrorMsg(e);
            }
        }

        @Override
        public String getColumnName(int col) {
            String colname = new String(" ");
            if (this.tab.vs != null && col != 0) {
                try {
                    colname = this.tab.vs.at(col - 1).getName();
                }
                catch (Exception e) {
                    return "C " + col;
                }
            }
            return colname == "" ? "C " + col : colname;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0 && DataTable.this.editable;
        }
    }

    class DataTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = -3297048934317912993L;

        public DataTableColumnModel(DataTable tab) {
        }

        @Override
        public void addColumn(TableColumn col) {
            DataTable.this.cell.getComponent().setFont(JGRPrefs.DefaultFont);
            FontTracker.current.add((JTextComponent)DataTable.this.cell.getComponent());
            col.setCellEditor(DataTable.this.cell);
            col.setCellRenderer(new DataTableCellRenderer());
            if (col.getModelIndex() == 0) {
                col.setMaxWidth(40);
            }
            if (col.getHeaderValue().equals("row.names")) {
                DataTable.this.rownames = true;
                DataTable.this.dataTable.getColumnModel().getColumn(0).setMaxWidth(0);
                DataTable.this.dataTable.getColumnModel().getColumn(0).setMinWidth(0);
                DataTable.this.dataTable.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
                DataTable.this.dataTable.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
            }
            col.setMinWidth(50);
            super.addColumn(col);
        }

        @Override
        public TableColumn getColumn(int index) {
            return super.getColumn(index < 0 ? 0 : index);
        }

        @Override
        public void moveColumn(int columnIndex, int newIndex) {
            if (columnIndex < 0 || columnIndex >= this.getColumnCount() || newIndex < 0 || newIndex >= this.getColumnCount()) {
                return;
            }
            super.moveColumn(columnIndex, newIndex);
            if (columnIndex == 0 || newIndex == 0 || DataTable.this.rownames && (columnIndex == 1 || newIndex == 1)) {
                super.moveColumn(newIndex, columnIndex);
            }
        }
    }
}

