/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class WeibullDist
extends ContinuousDistribution {
    private double alpha;
    private double lambda;
    private double delta;

    public WeibullDist(double d) {
        this.setParams(d, 1.0, 0.0);
    }

    public WeibullDist(double d, double d2, double d3) {
        this.setParams(d, d2, d3);
    }

    public double density(double d) {
        return WeibullDist.density(this.alpha, this.lambda, this.delta, d);
    }

    public double cdf(double d) {
        return WeibullDist.cdf(this.alpha, this.lambda, this.delta, d);
    }

    public double barF(double d) {
        return WeibullDist.barF(this.alpha, this.lambda, this.delta, d);
    }

    public double inverseF(double d) {
        return WeibullDist.inverseF(this.alpha, this.lambda, this.delta, d);
    }

    public double getMean() {
        return WeibullDist.getMean(this.alpha, this.lambda, this.delta);
    }

    public double getVariance() {
        return WeibullDist.getVariance(this.alpha, this.lambda, this.delta);
    }

    public double getStandardDeviation() {
        return WeibullDist.getStandardDeviation(this.alpha, this.lambda, this.delta);
    }

    public static double density(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d4 <= d3) {
            return 0.0;
        }
        double d5 = Math.log(d2 * (d4 - d3)) * d;
        if (d5 >= 7.0) {
            return 0.0;
        }
        d5 = Math.exp(d5);
        return d * (d5 / (d4 - d3)) * Math.exp(-d5);
    }

    public static double density(double d, double d2) {
        return WeibullDist.density(d, 1.0, 0.0, d2);
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d4 <= d3) {
            return 0.0;
        }
        if (d >= 1.0 && d2 * (d4 - d3) >= 1000.0) {
            return 1.0;
        }
        double d5 = Math.log(d2 * (d4 - d3)) * d;
        if (d5 >= 5.0) {
            return 1.0;
        }
        d5 = Math.exp(d5);
        return -Math.expm1(-d5);
    }

    public static double cdf(double d, double d2) {
        return WeibullDist.cdf(d, 1.0, 0.0, d2);
    }

    public static double barF(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d4 <= d3) {
            return 1.0;
        }
        if (d >= 1.0 && d4 >= 2048.0) {
            return 0.0;
        }
        double d5 = Math.log(d2 * (d4 - d3)) * d;
        if (d5 >= 709.782712893384) {
            return 0.0;
        }
        d5 = Math.exp(d5);
        return Math.exp(-d5);
    }

    public static double barF(double d, double d2) {
        return WeibullDist.barF(d, 1.0, 0.0, d2);
    }

    public static double inverseF(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d4 < 0.0 || d4 > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (d4 <= 0.0) {
            return 0.0;
        }
        if (d4 >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d5 = -Math.log1p(-d4);
        if (Math.log(d5) / Math.log(10.0) >= d * 308.0) {
            throw new ArithmeticException("inverse function cannot be positive infinity");
        }
        return Math.pow(d5, 1.0 / d) / d2 + d3;
    }

    public static double inverseF(double d, double d2) {
        return WeibullDist.inverseF(d, 1.0, 0.0, d2);
    }

    private static double[] getMaximumLikelihoodEstimate(double[] dArray, int n, double d) {
        double d2;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (d != 0.0) {
            throw new IllegalArgumentException("delta must be equal to 0");
        }
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = dArray[i] <= d ? -709.089565712824 : Math.log(dArray[i]);
            d3 += d5;
            d4 += d5 * d5;
        }
        double d6 = Math.sqrt((double)n / (0.6079271018540267 * (d4 - d3 * d3 / (double)n)));
        double d7 = d6 - 1.0;
        if (d2 <= d) {
            d7 = d + 1.0E-5;
        }
        double[] dArray2 = new double[3];
        dArray2[2] = 0.0;
        Function function = new Function(dArray, n);
        dArray2[0] = RootFinder.brentDekker(d7, d6 + 1.0, function, 1.0E-15);
        double d8 = 0.0;
        for (int i = 0; i < n; ++i) {
            d8 += Math.pow(dArray[i], dArray2[0]);
        }
        dArray2[1] = Math.pow((double)n / d8, 1.0 / dArray2[0]);
        return dArray2;
    }

    public static double[] getMLE(double[] dArray, int n) {
        return WeibullDist.getMaximumLikelihoodEstimate(dArray, n, 0.0);
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        return WeibullDist.getMLE(dArray, n);
    }

    public static WeibullDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = WeibullDist.getMaximumLikelihoodEstimate(dArray, n);
        return new WeibullDist(dArray2[0], dArray2[1], dArray2[2]);
    }

    public static double getMean(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return d3 + Math.exp(Num.lnGamma(1.0 + 1.0 / d)) / d2;
    }

    public static double getVariance(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        double d4 = Math.exp(Num.lnGamma(1.0 / d + 1.0));
        return Math.abs(Math.exp(Num.lnGamma(2.0 / d + 1.0)) - d4 * d4) / (d2 * d2);
    }

    public static double getStandardDeviation(double d, double d2, double d3) {
        return Math.sqrt(WeibullDist.getVariance(d, d2, d3));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setParams(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = d;
        this.lambda = d2;
        this.delta = d3;
        this.supportA = d3;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.alpha, this.lambda, this.delta};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : alpha = " + this.alpha + ", lambda = " + this.lambda + ", delta = " + this.delta;
    }

    private static class Function
    implements MathFunction {
        private int n;
        private double[] xi;
        private double[] lnXi;
        private double sumLnXi = 0.0;
        private final double LN_EPS = -709.089565712824;

        public Function(double[] dArray, int n) {
            this.n = n;
            this.xi = new double[n];
            this.lnXi = new double[n];
            for (int i = 0; i < n; ++i) {
                this.xi[i] = dArray[i];
                this.lnXi[i] = dArray[i] > 0.0 ? Math.log(dArray[i]) : -709.089565712824;
                this.sumLnXi += this.lnXi[i];
            }
        }

        public double evaluate(double d) {
            if (d <= 0.0) {
                return 1.0E200;
            }
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < this.n; ++i) {
                double d4 = Math.pow(this.xi[i], d);
                d2 += d4 * this.lnXi[i];
                d3 += d4;
            }
            return d * ((double)this.n * d2 - this.sumLnXi * d3) - (double)this.n * d3;
        }
    }
}

