/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.sim;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.act.rscat.cat.CatEngine;
import org.act.rscat.cat.CatHelper;
import org.act.rscat.cat.CatInput;
import org.act.rscat.cat.CatOutput;
import org.act.rscat.cat.ItemScores;
import org.act.rscat.cat.PassageOrItemEligibilityAtThetaRange;
import org.act.rscat.cat.PassageOrItemEligibilityOverall;
import org.act.rscat.cat.ThetaEst;
import org.act.rscat.sim.AbstractCatSimulationTask;
import org.act.rscat.sim.SimOutput;
import org.act.rscat.sim.SimulationFunctions;
import org.act.rscat.sol.InfeasibleTestConfigException;
import org.apache.commons.math3.linear.RealMatrix;

public class CatSimulationTaskStandard
extends AbstractCatSimulationTask {
    private PassageOrItemEligibilityOverall eligibility;

    public CatSimulationTaskStandard(String studentId, double trueTheta, CatEngine engine, CatInput catInput, PassageOrItemEligibilityOverall eligibility) {
        super(studentId, trueTheta, engine, catInput);
        this.eligibility = eligibility;
    }

    @Override
    public SimOutput runSimTask(boolean generateOutput) throws IOException, InfeasibleTestConfigException {
        List<String> itemIds = this.getCatInput().getItemIds();
        RealMatrix itemPoolParams = CatHelper.getItemParams(this.getCatInput().getItemPoolDataSet());
        Map<String, Integer> itemToPassageIndexMap = SimulationFunctions.getItemIdToPassageIndexMap(this.getCatInput().getTestConfig().getItemPoolTable(), this.getCatInput().getTestConfig().getPassageTable());
        ArrayList<ItemScores> itemScoresList = new ArrayList<ItemScores>();
        List<String> itemsToAdminThisStage = null;
        int testLength = this.getCatInput().getTestConfig().getTestLength();
        ArrayList<PassageOrItemEligibilityAtThetaRange> passageOrItemEligibilityAtThetaRangeList = new ArrayList<PassageOrItemEligibilityAtThetaRange>(this.getCatInput().getTestConfig().getItemPoolTable().rowCount());
        ArrayList<List<String>> shadowTestList = new ArrayList<List<String>>(testLength);
        ArrayList<ThetaEst> thetaEstList = new ArrayList<ThetaEst>(testLength);
        ArrayList<Double> catEngineTimeList = new ArrayList<Double>();
        ArrayList<List<Integer>> passageRowIndexSequences = new ArrayList<List<Integer>>();
        ArrayList<Integer> adaptiveStageList = new ArrayList<Integer>();
        ThetaEst finalThetaEst = null;
        for (int stage = 0; stage < this.getCatInput().getTestConfig().getTestLength(); ++stage) {
            CatOutput catOutput = this.getEngine().runsCatCycle(this.getCatInput());
            itemsToAdminThisStage = catOutput.getItemsToAdminister().getItemsToAdmin();
            if (!itemsToAdminThisStage.isEmpty()) {
                RealMatrix itemParamsForScoring = CatHelper.getItemParamsForScoring(itemIds, itemsToAdminThisStage, itemPoolParams);
                itemScoresList.add(SimulationFunctions.simItemScores(itemParamsForScoring, this.getTrueTheta()));
            }
            if (generateOutput) {
                passageOrItemEligibilityAtThetaRangeList.add(catOutput.getPassageOrItemEligibilityAtThetaRange());
                shadowTestList.add(catOutput.getShadowTest());
                thetaEstList.add(catOutput.getThetaEst());
                catEngineTimeList.add(catOutput.getCatEngineTime());
                passageRowIndexSequences.add(this.getCatInput().getAdministeredPassageIndexSequence());
                adaptiveStageList.add(stage);
            }
            int nextStage = stage + 1;
            this.setCatInput(CatHelper.createNextCatInput(this.getCatInput(), (ItemScores)itemScoresList.get(stage), itemsToAdminThisStage, nextStage, itemToPassageIndexMap, this.eligibility, catOutput));
        }
        CatOutput catOutput = this.getEngine().runsCatCycle(this.getCatInput());
        finalThetaEst = catOutput.getThetaEst();
        ArrayList<String> itemsAdministered = new ArrayList<String>(catOutput.getItemsToAdminister().getListItemsAlreadyAdministered());
        if (generateOutput) {
            passageOrItemEligibilityAtThetaRangeList.add(catOutput.getPassageOrItemEligibilityAtThetaRange());
            shadowTestList.add(catOutput.getShadowTest());
            thetaEstList.add(catOutput.getThetaEst());
            catEngineTimeList.add(catOutput.getCatEngineTime());
            passageRowIndexSequences.add(this.getCatInput().getAdministeredPassageIndexSequence());
            adaptiveStageList.add(this.getCatInput().getTestConfig().getTestLength());
        }
        return new SimOutput.Builder(this.getStudentId(), this.getTrueTheta()).adaptiveStageList(adaptiveStageList).catEngineTimeList(catEngineTimeList).finalTheta(finalThetaEst).initTheta(this.getCatInput().getCatConfig().initTheta()).itemEligibilityList(passageOrItemEligibilityAtThetaRangeList).itemsAdministered(itemsAdministered).itemScoresList(itemScoresList).passageRowIndexSequences(passageRowIndexSequences).shadowTestList(shadowTestList).thetaEstList(thetaEstList).build();
    }
}

