/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorEvaluationMonitor;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.Span;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.FMeasure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceDetectorEvaluator
extends Evaluator<SentenceSample> {
    private FMeasure fmeasure = new FMeasure();
    private SentenceDetector sentenceDetector;

    public SentenceDetectorEvaluator(SentenceDetector sentenceDetector, SentenceDetectorEvaluationMonitor ... listeners) {
        super(listeners);
        this.sentenceDetector = sentenceDetector;
    }

    @Override
    protected SentenceSample processSample(SentenceSample sample) {
        Object[] predictions = this.sentenceDetector.sentPosDetect(sample.getDocument());
        Object[] references = sample.getSentences();
        this.fmeasure.updateScores(references, predictions);
        return new SentenceSample(sample.getDocument(), (Span[])predictions);
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

