/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.cmdline.tokenizer.TokenizerModelLoader;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.DirectorySampleStream;
import opennlp.tools.formats.convert.FileToStringSampleStream;
import opennlp.tools.formats.muc.MucNameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Muc6NameSampleStreamFactory
extends AbstractSampleStreamFactory<NameSample> {
    protected Muc6NameSampleStreamFactory() {
        super(Parameters.class);
    }

    @Override
    public ObjectStream<NameSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        TokenizerModel tokenizerModel = (TokenizerModel)new TokenizerModelLoader().load(params.getTokenizerModel());
        TokenizerME tokenizer = new TokenizerME(tokenizerModel);
        FileToStringSampleStream mucDocStream = new FileToStringSampleStream(new DirectorySampleStream(params.getData(), new FileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".sgm");
            }
        }, false), Charset.forName("UTF-8"));
        return new MucNameSampleStream(tokenizer, mucDocStream);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "muc6", new Muc6NameSampleStreamFactory());
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="modelFile")
        public File getTokenizerModel();
    }
}

