/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.http;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HttpHeader {
    private Hashtable headers = new Hashtable();
    private String head;

    public void setHeaderValue(String string, String string2) {
        this.headers.put(string.toLowerCase(), string2);
    }

    public String getHead() {
        return this.head;
    }

    public int getContentLength() {
        int n = 0;
        String string = this.getHeaderValue("content-length");
        if (string != null) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    public String getHeaderValue(String string) {
        return (String)this.headers.get(string);
    }

    public String removeHeaderValue(String string) {
        return (String)this.headers.remove(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.headers.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.headers.get(string);
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(string2);
            stringBuffer.append("\r\n");
        }
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    private static Hashtable parseHeader(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = (string2 = string2.trim()).indexOf(":");
            if (n <= -1) continue;
            String string3 = string2.substring(0, n).trim().toLowerCase();
            String string4 = string2.substring(n + 1).trim();
            hashtable.put(string3, string4);
        }
        return hashtable;
    }

    public static HttpHeader fromString(String string) {
        HttpHeader httpHeader = new HttpHeader();
        int n = string.indexOf("\r\n");
        httpHeader.head = string.substring(0, n);
        httpHeader.headers = HttpHeader.parseHeader(string);
        return httpHeader;
    }
}

