/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.graph.ConnectedComponents;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.tools.manipulator.SgroupManipulator;

public class ConnectivityChecker {
    public static boolean isConnected(IAtomContainer atomContainer) {
        if (atomContainer.getAtomCount() < 2) {
            return true;
        }
        ConnectedComponents cc = new ConnectedComponents(GraphUtil.toAdjList((IAtomContainer)atomContainer));
        return cc.nComponents() == 1;
    }

    public static IAtomContainerSet partitionIntoMolecules(IAtomContainer container) {
        ConnectedComponents cc = new ConnectedComponents(GraphUtil.toAdjList((IAtomContainer)container));
        if (cc.nComponents() == 1) {
            return ConnectivityChecker.singleton(container);
        }
        return ConnectivityChecker.partitionIntoMolecules(container, cc.components());
    }

    private static IAtomContainerSet singleton(IAtomContainer container) {
        IChemObjectBuilder bldr = container.getBuilder();
        IAtomContainerSet acSet = (IAtomContainerSet)bldr.newInstance(IAtomContainerSet.class, new Object[0]);
        acSet.addAtomContainer(container);
        return acSet;
    }

    private static IAtomContainerSet empty(IAtomContainer container) {
        IChemObjectBuilder bldr = container.getBuilder();
        return (IAtomContainerSet)bldr.newInstance(IAtomContainerSet.class, new Object[0]);
    }

    private static IAtomContainer getComponent(Map<IAtom, IAtomContainer> cmap, IChemObject cobj) {
        if (cobj instanceof IAtom) {
            return cmap.get(cobj);
        }
        if (cobj instanceof IBond) {
            IAtomContainer endMol;
            IAtomContainer begMol = cmap.get(((IBond)cobj).getBegin());
            return begMol == (endMol = cmap.get(((IBond)cobj).getEnd())) ? begMol : null;
        }
        return null;
    }

    private static IAtomContainer getComponent(Map<IAtom, IAtomContainer> cmap, IStereoElement<?, ?> se) {
        IAtomContainer mol = ConnectivityChecker.getComponent(cmap, se.getFocus());
        for (IChemObject cobj : se.getCarriers()) {
            IAtomContainer tmp = ConnectivityChecker.getComponent(cmap, cobj);
            if (tmp == mol) continue;
            return null;
        }
        return mol;
    }

    private static IAtomContainer getComponent(Map<IAtom, IAtomContainer> cmap, Sgroup sgroup) {
        IAtomContainer mol = null;
        for (IAtom atom : sgroup.getAtoms()) {
            IAtomContainer tmp = cmap.get(atom);
            if (mol == null) {
                mol = tmp;
                continue;
            }
            if (mol == tmp) continue;
            return null;
        }
        return mol;
    }

    private static void addSgroup(IAtomContainer component, Sgroup sgroup) {
        ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)component.getProperty((Object)"cdk:CtabSgroups");
        if (sgroups == null) {
            sgroups = new ArrayList<Sgroup>();
            component.setProperty((Object)"cdk:CtabSgroups", sgroups);
        }
        sgroups.add(sgroup);
    }

    public static IAtomContainerSet partitionIntoMolecules(IAtomContainer container, int[] components) {
        int minComponentIndex = Integer.MAX_VALUE;
        int maxComponentIndex = 0;
        for (int component : components) {
            minComponentIndex = Math.min(component, minComponentIndex);
            maxComponentIndex = Math.max(component, maxComponentIndex);
        }
        if (minComponentIndex == maxComponentIndex) {
            if (maxComponentIndex == 0) {
                return ConnectivityChecker.empty(container);
            }
            return ConnectivityChecker.singleton(container);
        }
        IAtomContainer[] containers = new IAtomContainer[maxComponentIndex + 1];
        HashMap<IAtom, IAtomContainer> componentsMap = new HashMap<IAtom, IAtomContainer>(2 * container.getAtomCount());
        for (int i = 1; i < containers.length; ++i) {
            containers[i] = (IAtomContainer)container.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        }
        IAtomContainerSet containerSet = (IAtomContainerSet)container.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom origAtom = container.getAtom(i);
            IAtomContainer newContainer = containers[components[i]];
            componentsMap.put(origAtom, newContainer);
            newContainer.addAtom(origAtom);
        }
        for (IBond bond : container.bonds()) {
            IAtomContainer endComp;
            IAtomContainer begComp = (IAtomContainer)componentsMap.get(bond.getBegin());
            if (begComp != (endComp = (IAtomContainer)componentsMap.get(bond.getEnd()))) continue;
            begComp.addBond(bond);
        }
        for (ISingleElectron electron : container.singleElectrons()) {
            ((IAtomContainer)componentsMap.get(electron.getAtom())).addSingleElectron(electron);
        }
        for (ILonePair lonePair : container.lonePairs()) {
            ((IAtomContainer)componentsMap.get(lonePair.getAtom())).addLonePair(lonePair);
        }
        for (IStereoElement stereo : container.stereoElements()) {
            IAtomContainer component = ConnectivityChecker.getComponent(componentsMap, stereo);
            if (component == null) continue;
            component.addStereoElement(stereo);
        }
        List sgroups = SgroupManipulator.copy((Collection)((Collection)container.getProperty((Object)"cdk:CtabSgroups")), new HashMap());
        if (sgroups != null) {
            HashMap sgroupMap = new HashMap();
            for (Sgroup sgroup : sgroups) {
                IAtomContainer component = ConnectivityChecker.getComponent(componentsMap, sgroup);
                if (component == null) continue;
                ConnectivityChecker.addSgroup(component, sgroup);
            }
            for (Sgroup sgroup : sgroups) {
                HashSet<Sgroup> toremove = new HashSet<Sgroup>();
                for (Sgroup parent : sgroup.getParents()) {
                    if (sgroupMap.get(parent) != null) continue;
                    toremove.add(parent);
                }
                sgroup.removeParents(toremove);
            }
        }
        for (int i = 1; i < containers.length; ++i) {
            containerSet.addAtomContainer(containers[i]);
        }
        return containerSet;
    }
}

