/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.Angiulli;

import com.yahoo.labs.samoa.instances.Instance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import moa.clusterers.outliers.Angiulli.MyMTree;
import moa.clusterers.outliers.Angiulli.StreamObj;
import moa.clusterers.outliers.utils.mtree.MTree;

public class ISBIndex {
    MyMTree mtree = new MyMTree();
    Map<Integer, Set<ISBNode>> mapNodes = new HashMap<Integer, Set<ISBNode>>();
    double m_radius;
    int m_k;

    public ISBIndex(double radius, int k) {
        this.m_radius = radius;
        this.m_k = k;
    }

    public Vector<ISBSearchResult> RangeSearch(ISBNode node, double radius) {
        Vector<ISBSearchResult> results = new Vector<ISBSearchResult>();
        MTree.Query query = this.mtree.getNearestByRange(node.obj, radius);
        for (MTree.ResultItem q : query) {
            StreamObj obj = (StreamObj)q.data;
            double d = q.distance;
            Vector<ISBNode> nodes = this.MapGetNodes(obj);
            for (int i = 0; i < nodes.size(); ++i) {
                results.add(new ISBSearchResult(nodes.get(i), d));
            }
        }
        return results;
    }

    public void Insert(ISBNode node) {
        this.mtree.add(node.obj);
        this.MapInsert(node);
    }

    public void Remove(ISBNode node) {
        this.MapDelete(node);
        if (this.MapCountObjRefs(node.obj) <= 0) {
            this.mtree.remove(node.obj);
        }
    }

    Vector<ISBNode> MapGetNodes(StreamObj obj) {
        int h = obj.hashCode();
        Vector<ISBNode> v = new Vector<ISBNode>();
        if (this.mapNodes.containsKey(h)) {
            Set<ISBNode> s = this.mapNodes.get(h);
            for (ISBNode node : s) {
                if (!node.obj.equals(obj)) continue;
                v.add(node);
            }
        }
        return v;
    }

    int MapCountObjRefs(StreamObj obj) {
        int h = obj.hashCode();
        int iCount = 0;
        if (this.mapNodes.containsKey(h)) {
            Set<ISBNode> s = this.mapNodes.get(h);
            for (ISBNode n : s) {
                if (!n.obj.equals(obj)) continue;
                ++iCount;
            }
        }
        return iCount;
    }

    void MapInsert(ISBNode node) {
        int h = node.obj.hashCode();
        if (this.mapNodes.containsKey(h)) {
            Set<ISBNode> s = this.mapNodes.get(h);
            s.add(node);
        } else {
            HashSet<ISBNode> s = new HashSet<ISBNode>();
            s.add(node);
            this.mapNodes.put(h, s);
        }
    }

    void MapDelete(ISBNode node) {
        int h = node.obj.hashCode();
        if (this.mapNodes.containsKey(h)) {
            Set<ISBNode> s = this.mapNodes.get(h);
            s.remove(node);
            if (s.isEmpty()) {
                this.mapNodes.remove(h);
            }
        }
    }

    public static class ISBSearchResult {
        public ISBNode node;
        public double distance;

        public ISBSearchResult(ISBNode n, double distance) {
            this.node = n;
            this.distance = distance;
        }
    }

    public static abstract class ISBNode {
        public Instance inst;
        public StreamObj obj;
        public Long id;
        public int nOutlier;
        public int nInlier;

        public ISBNode(Instance inst, StreamObj obj, Long id) {
            this.inst = inst;
            this.obj = obj;
            this.id = id;
            this.nOutlier = 0;
            this.nInlier = 0;
        }
    }
}

