/*
 * Decompiled with CFR 0.152.
 */
package moa.core;

import java.util.ArrayList;
import moa.AbstractMOAObject;
import moa.core.GaussianEstimator;
import moa.core.StringUtils;

public class Measurement
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected double value;

    public Measurement(String name, double value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public static Measurement getMeasurementNamed(String name, Measurement[] measurements) {
        for (Measurement measurement : measurements) {
            if (!name.equals(measurement.getName())) continue;
            return measurement;
        }
        return null;
    }

    public static void getMeasurementsDescription(Measurement[] measurements, StringBuilder out, int indent) {
        if (measurements.length > 0) {
            StringUtils.appendIndented(out, indent, measurements[0].toString());
            for (int i = 1; i < measurements.length; ++i) {
                StringUtils.appendNewlineIndented(out, indent, measurements[i].toString());
            }
        }
    }

    public static Measurement[] averageMeasurements(Measurement[][] toAverage) {
        int n;
        ArrayList<String> measurementNames = new ArrayList<String>();
        Measurement[][] measurementArray = toAverage;
        int n2 = measurementArray.length;
        for (n = 0; n < n2; ++n) {
            Measurement[] measurements;
            for (Measurement measurement : measurements = measurementArray[n]) {
                if (measurementNames.indexOf(measurement.getName()) >= 0) continue;
                measurementNames.add(measurement.getName());
            }
        }
        GaussianEstimator[] estimators = new GaussianEstimator[measurementNames.size()];
        for (int i = 0; i < estimators.length; ++i) {
            estimators[i] = new GaussianEstimator();
        }
        Measurement[][] i = toAverage;
        n = i.length;
        for (int measurements = 0; measurements < n; ++measurements) {
            Measurement[] measurements2;
            for (Measurement measurement : measurements2 = i[measurements]) {
                estimators[measurementNames.indexOf(measurement.getName())].addObservation(measurement.getValue(), 1.0);
            }
        }
        ArrayList<Measurement> averagedMeasurements = new ArrayList<Measurement>();
        for (int i2 = 0; i2 < measurementNames.size(); ++i2) {
            String mName = (String)measurementNames.get(i2);
            GaussianEstimator mEstimator = estimators[i2];
            if (mEstimator.getTotalWeightObserved() > 1.0) {
                averagedMeasurements.add(new Measurement("[avg] " + mName, mEstimator.getMean()));
                averagedMeasurements.add(new Measurement("[err] " + mName, mEstimator.getStdDev()));
                continue;
            }
            averagedMeasurements.add(new Measurement("[avg] " + mName, 0.0));
            averagedMeasurements.add(new Measurement("[err] " + mName, 0.0));
        }
        return averagedMeasurements.toArray(new Measurement[averagedMeasurements.size()]);
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        sb.append(this.getName());
        sb.append(" = ");
        if (this.getValue() > 0.001) {
            sb.append(StringUtils.doubleToString(this.getValue(), 3));
        } else {
            sb.append(this.getValue());
        }
    }
}

