/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.IterativeClassifier;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.BatchPredictor;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PartitionGenerator;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.core.WekaException;
import weka.filters.Filter;
import weka.filters.supervised.attribute.AttributeSelection;
import weka.filters.supervised.attribute.Discretize;
import weka.filters.unsupervised.attribute.Reorder;

public class FilteredClassifier
extends RandomizableSingleClassifierEnhancer
implements Drawable,
PartitionGenerator,
IterativeClassifier,
BatchPredictor,
WeightedInstancesHandler,
WeightedAttributesHandler {
    static final long serialVersionUID = -4523450618538717400L;
    protected Filter m_Filter = new AttributeSelection();
    protected Instances m_FilteredInstances;
    protected boolean m_DoNotCheckForModifiedClassAttribute = false;
    protected Reorder m_ReorderOriginal;
    protected Reorder m_ReorderFiltered;

    public String globalInfo() {
        return "Class for running an arbitrary classifier on data that has been passed through an arbitrary filter. Like the classifier, the structure of the filter is based exclusively on the training data and test instances will be processed by the filter without changing their structure.\n\nIf unequal instance weights or attribute weights are present, and the filter or the classifier are unable to deal with them, the instances and/or attributes are resampled with replacement based on the weights before they are passed to the filter or the classifier (as appropriate).";
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    protected String defaultFilterString() {
        return "weka.filters.supervised.attribute.Discretize -R first-last -precision 6";
    }

    public FilteredClassifier() {
        this.m_Classifier = new J48();
        this.m_Filter = new Discretize();
    }

    @Override
    public int graphType() {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graphType();
        }
        return 0;
    }

    @Override
    public String graph() throws Exception {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graph();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot be graphed");
    }

    @Override
    public void generatePartition(Instances data) throws Exception {
        if (!(this.m_Classifier instanceof PartitionGenerator)) {
            throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot generate a partition");
        }
        this.buildClassifier(data);
    }

    @Override
    public double[] getMembershipValues(Instance inst) throws Exception {
        if (this.m_Classifier instanceof PartitionGenerator) {
            Instance newInstance;
            if (this.m_ReorderOriginal != null) {
                this.m_ReorderOriginal.input(inst);
                inst = this.m_ReorderOriginal.output();
            }
            if ((newInstance = this.filterInstance(inst)) == null) {
                double[] unclassified = new double[this.numElements()];
                for (int i = 0; i < unclassified.length; ++i) {
                    unclassified[i] = Utils.missingValue();
                }
                return unclassified;
            }
            if (this.m_ReorderFiltered != null) {
                this.m_ReorderFiltered.input(newInstance);
                newInstance = this.m_ReorderFiltered.output();
            }
            return ((PartitionGenerator)((Object)this.m_Classifier)).getMembershipValues(newInstance);
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot generate a partition");
    }

    @Override
    public int numElements() throws Exception {
        if (this.m_Classifier instanceof PartitionGenerator) {
            return ((PartitionGenerator)((Object)this.m_Classifier)).numElements();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot generate a partition");
    }

    @Override
    public void initializeClassifier(Instances data) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception("No base classifier has been set!");
        }
        this.getCapabilities().testWithFail(data);
        if (this.m_Classifier instanceof IterativeClassifier) {
            Random r = data.numInstances() > 0 ? data.getRandomNumberGenerator(this.getSeed()) : new Random(this.getSeed());
            if (!(data = this.setUp(data, r)).allInstanceWeightsIdentical() && !(this.m_Classifier instanceof WeightedInstancesHandler)) {
                data = data.resampleWithWeights(r);
            }
            if (!data.allAttributeWeightsIdentical() && !(this.m_Classifier instanceof WeightedAttributesHandler)) {
                data = this.resampleAttributes(data, false, r);
            }
            this.getClassifier().getCapabilities().testWithFail(data);
            if (this.m_Classifier instanceof Randomizable) {
                ((Randomizable)((Object)this.m_Classifier)).setSeed(r.nextInt());
            }
        } else {
            throw new Exception("Classifier: " + this.getClassifierSpec() + " is not an IterativeClassifier");
        }
        ((IterativeClassifier)this.m_Classifier).initializeClassifier(data);
    }

    @Override
    public boolean next() throws Exception {
        if (this.m_Classifier instanceof IterativeClassifier) {
            return ((IterativeClassifier)this.m_Classifier).next();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " is not an IterativeClassifier");
    }

    @Override
    public void done() throws Exception {
        if (!(this.m_Classifier instanceof IterativeClassifier)) {
            throw new Exception("Classifier: " + this.getClassifierSpec() + " is not an IterativeClassifier");
        }
        ((IterativeClassifier)this.m_Classifier).done();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tFull class name of filter to use, followed\n\tby filter options.\n\tdefault: \"" + this.defaultFilterString() + "\"", "F", 1, "-F <filter specification>"));
        newVector.addElement(new Option("\tIf set, classifier will not check whether the filter modifies the class (use with caution).", "doNotCheckForModifiedClassAttribute", 0, "-doNotCheckForModifiedClassAttribute"));
        newVector.addAll(Collections.list(super.listOptions()));
        if (this.getFilter() instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.getFilter().getClass().getName() + ":"));
            newVector.addAll(Collections.list(this.getFilter().listOptions()));
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String[] filterSpec;
        String filterString = Utils.getOption('F', options);
        if (filterString.length() <= 0) {
            filterString = this.defaultFilterString();
        }
        if ((filterSpec = Utils.splitOptions(filterString)).length == 0) {
            throw new IllegalArgumentException("Invalid filter specification string");
        }
        String filterName = filterSpec[0];
        filterSpec[0] = "";
        this.setFilter((Filter)Utils.forName(Filter.class, filterName, filterSpec));
        this.setDoNotCheckForModifiedClassAttribute(Utils.getFlag("doNotCheckForModifiedClassAttribute", options));
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    public String doNotCheckForModifiedClassAttributeTipText() {
        return "Turns off check for modified class attribute - use with caution.";
    }

    public boolean getDoNotCheckForModifiedClassAttribute() {
        return this.m_DoNotCheckForModifiedClassAttribute;
    }

    public void setDoNotCheckForModifiedClassAttribute(boolean flag) {
        this.m_DoNotCheckForModifiedClassAttribute = flag;
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-F");
        options.add("" + this.getFilterSpec());
        if (this.getDoNotCheckForModifiedClassAttribute()) {
            options.add("-doNotCheckForModifiedClassAttribute");
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    protected String getFilterSpec() {
        Filter c = this.getFilter();
        if (c instanceof OptionHandler) {
            return c.getClass().getName() + " " + Utils.joinOptions(c.getOptions());
        }
        return c.getClass().getName();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.getFilter() == null) {
            result = super.getCapabilities();
        } else {
            result = this.getFilter().getCapabilities();
            if (!this.getDoNotCheckForModifiedClassAttribute()) {
                Capabilities classes = super.getCapabilities().getClassCapabilities();
                Iterator<Capabilities.Capability> iter = classes.capabilities();
                result.disableAllClasses();
                while (iter.hasNext()) {
                    result.enable(iter.next());
                }
            }
        }
        result.disable(Capabilities.Capability.NO_CLASS);
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        result.setOwner(this);
        return result;
    }

    protected Instances setUp(Instances data, Random random) throws Exception {
        this.m_ReorderOriginal = null;
        this.m_ReorderFiltered = null;
        if (!(data = data.allInstanceWeightsIdentical() || this.m_Filter instanceof WeightedInstancesHandler ? new Instances(data) : data.resampleWithWeights(random)).allAttributeWeightsIdentical() && !(this.m_Filter instanceof WeightedAttributesHandler)) {
            data = this.resampleAttributes(data, true, random);
        }
        Attribute classAttribute = (Attribute)data.classAttribute().copy();
        if (this.m_Filter instanceof Randomizable) {
            ((Randomizable)((Object)this.m_Filter)).setSeed(random.nextInt());
        }
        this.m_Filter.setInputFormat(data);
        data = Filter.useFilter(data, this.m_Filter);
        if (!classAttribute.equals(data.classAttribute()) && !this.m_DoNotCheckForModifiedClassAttribute) {
            throw new IllegalArgumentException("Cannot proceed: " + this.getFilterSpec() + " has modified the class attribute!");
        }
        this.m_FilteredInstances = data.stringFreeStructure();
        return data;
    }

    protected Instances resampleAttributes(Instances data, boolean original, Random random) throws Exception {
        int nAtt = data.classIndex() >= 0 ? data.numAttributes() - 1 : data.numAttributes();
        int index = 0;
        double[] attributeWeights = new double[nAtt];
        for (int i = 0; i < data.numAttributes(); ++i) {
            if (i == data.classIndex()) continue;
            attributeWeights[index++] = data.attribute(i).weight();
        }
        int[] frequencies = Utils.takeSample(attributeWeights, random);
        ArrayList<Integer> al = new ArrayList<Integer>();
        index = 0;
        for (int j2 = 0; j2 < data.numAttributes(); ++j2) {
            if (j2 == data.classIndex()) {
                al.add(j2);
                continue;
            }
            for (int i = 0; i < frequencies[index]; ++i) {
                al.add(j2);
            }
            ++index;
        }
        if (original) {
            this.m_ReorderOriginal = new Reorder();
            this.m_ReorderOriginal.setAttributeIndicesArray(al.stream().mapToInt(j -> j).toArray());
            this.m_ReorderOriginal.setAllAttributeWeightsToOne(true);
            this.m_ReorderOriginal.setInputFormat(data);
            return Filter.useFilter(data, this.m_ReorderOriginal);
        }
        this.m_ReorderFiltered = new Reorder();
        this.m_ReorderFiltered.setAttributeIndicesArray(al.stream().mapToInt(j -> j).toArray());
        this.m_ReorderFiltered.setAllAttributeWeightsToOne(true);
        this.m_ReorderFiltered.setInputFormat(data);
        return Filter.useFilter(data, this.m_ReorderFiltered);
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception("No base classifier has been set!");
        }
        this.getCapabilities().testWithFail(data);
        Random r = data.numInstances() > 0 ? data.getRandomNumberGenerator(this.getSeed()) : new Random(this.getSeed());
        data = this.setUp(data, r);
        if (!data.allInstanceWeightsIdentical() && !(this.m_Classifier instanceof WeightedInstancesHandler)) {
            data = data.resampleWithWeights(r);
        }
        if (!data.allAttributeWeightsIdentical() && !(this.m_Classifier instanceof WeightedAttributesHandler)) {
            data = this.resampleAttributes(data, false, r);
        }
        this.getClassifier().getCapabilities().testWithFail(data);
        if (this.m_Classifier instanceof Randomizable) {
            ((Randomizable)((Object)this.m_Classifier)).setSeed(r.nextInt());
        }
        this.m_Classifier.buildClassifier(data);
    }

    protected Instance filterInstance(Instance instance) throws Exception {
        if (this.m_Filter.numPendingOutput() > 0) {
            throw new Exception("Filter output queue not empty!");
        }
        if (!this.m_Filter.input(instance)) {
            if (!this.m_Filter.mayRemoveInstanceAfterFirstBatchDone()) {
                throw new Exception("Filter didn't make the test instance immediately available!");
            }
            this.m_Filter.batchFinished();
            return null;
        }
        this.m_Filter.batchFinished();
        return this.m_Filter.output();
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        Instance newInstance;
        if (this.m_ReorderOriginal != null) {
            this.m_ReorderOriginal.input(instance);
            instance = this.m_ReorderOriginal.output();
        }
        if ((newInstance = this.filterInstance(instance)) == null) {
            double[] unclassified = null;
            unclassified = instance.classAttribute().isNumeric() ? new double[]{Utils.missingValue()} : new double[instance.classAttribute().numValues()];
            return unclassified;
        }
        if (this.m_ReorderFiltered != null) {
            this.m_ReorderFiltered.input(newInstance);
            newInstance = this.m_ReorderFiltered.output();
        }
        return this.m_Classifier.distributionForInstance(newInstance);
    }

    @Override
    public String batchSizeTipText() {
        return "Batch size to use if base learner is a BatchPredictor";
    }

    @Override
    public void setBatchSize(String size) {
        if (this.getClassifier() instanceof BatchPredictor) {
            ((BatchPredictor)((Object)this.getClassifier())).setBatchSize(size);
        } else {
            super.setBatchSize(size);
        }
    }

    @Override
    public String getBatchSize() {
        if (this.getClassifier() instanceof BatchPredictor) {
            return ((BatchPredictor)((Object)this.getClassifier())).getBatchSize();
        }
        return super.getBatchSize();
    }

    @Override
    public double[][] distributionsForInstances(Instances insts) throws Exception {
        if (this.getClassifier() instanceof BatchPredictor) {
            Instances filteredInsts;
            if (this.m_ReorderOriginal != null) {
                insts = Filter.useFilter(insts, this.m_ReorderOriginal);
            }
            if ((filteredInsts = Filter.useFilter(insts, this.m_Filter)).numInstances() != insts.numInstances()) {
                throw new WekaException("FilteredClassifier: filter has returned more/less instances than required.");
            }
            if (this.m_ReorderOriginal != null) {
                filteredInsts = Filter.useFilter(filteredInsts, this.m_ReorderFiltered);
            }
            return ((BatchPredictor)((Object)this.getClassifier())).distributionsForInstances(filteredInsts);
        }
        double[][] result = new double[insts.numInstances()][insts.numClasses()];
        for (int i = 0; i < insts.numInstances(); ++i) {
            result[i] = this.distributionForInstance(insts.instance(i));
        }
        return result;
    }

    @Override
    public boolean implementsMoreEfficientBatchPrediction() {
        if (!(this.getClassifier() instanceof BatchPredictor)) {
            return super.implementsMoreEfficientBatchPrediction();
        }
        return ((BatchPredictor)((Object)this.getClassifier())).implementsMoreEfficientBatchPrediction();
    }

    public String toString() {
        if (this.m_FilteredInstances == null) {
            return "FilteredClassifier: No model built yet.";
        }
        String result = "FilteredClassifier using " + this.getClassifierSpec() + " on data filtered through " + this.getFilterSpec() + "\n\nFiltered Header\n" + this.m_FilteredInstances.toString() + "\n\nClassifier Model\n" + this.m_Classifier.toString();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14608 $");
    }

    public static void main(String[] argv) {
        FilteredClassifier.runClassifier(new FilteredClassifier(), argv);
    }
}

