/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.EventListener;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.RepaintManager;

public class PrintManager
extends JPanel
implements Printable {
    private JTextPane printTextArea;
    private Paper currentPrintJobPaper;
    private JScrollBar scrollBar;
    private JDialog dialog;
    private boolean cancelled = false;
    private int cols;
    private int rows;

    public static void print(String string, Window window) {
        PrintManager.print(string, window, true, false);
    }

    public static void print(String string, Window window, boolean bl) {
        PrintManager.print(string, window, true, bl);
    }

    public static void print(String string, Window window, boolean bl, boolean bl2) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        double d = 2.83411155;
        double d2 = 71.98643;
        PageFormat pageFormat = printerJob.defaultPage();
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (bl2) {
            hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
        }
        if (printerJob.printDialog(hashPrintRequestAttributeSet)) {
            for (Attribute attribute : hashPrintRequestAttributeSet.toArray()) {
                if (attribute == OrientationRequested.LANDSCAPE) {
                    pageFormat.setOrientation(0);
                    continue;
                }
                if (attribute == OrientationRequested.PORTRAIT) {
                    pageFormat.setOrientation(1);
                    continue;
                }
                if (attribute != OrientationRequested.REVERSE_LANDSCAPE) continue;
                pageFormat.setOrientation(2);
            }
            for (Attribute attribute : hashPrintRequestAttributeSet.toArray()) {
                if (!(attribute instanceof MediaPrintableArea)) continue;
                MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)attribute;
                Paper paper = new Paper();
                if (pageFormat.getOrientation() == 0 || pageFormat.getOrientation() == 2) {
                    paper.setImageableArea(0.0, 0.0, d * (double)mediaPrintableArea.getHeight(1000), d * (double)mediaPrintableArea.getWidth(1000));
                } else {
                    paper.setImageableArea(0.0, 0.0, d * (double)mediaPrintableArea.getWidth(1000), d * (double)mediaPrintableArea.getHeight(1000));
                }
                pageFormat.setPaper(paper);
            }
            PrintManager printManager = new PrintManager(string, pageFormat.getPaper(), window);
            printerJob.setPrintable(printManager);
            if (bl) {
                super.showPreview();
            }
            if (!printManager.cancelled) {
                try {
                    printerJob.print(hashPrintRequestAttributeSet);
                }
                catch (PrinterException printerException) {
                    printerException.printStackTrace();
                }
            }
        }
    }

    public PrintManager(String string, Paper paper, Window window) {
        int n;
        this.currentPrintJobPaper = paper;
        this.printTextArea = new JTextPane();
        this.printTextArea.setContentType("text/html");
        this.printTextArea.setText(string);
        this.printTextArea.setEditable(false);
        MouseListener[] mouseListenerArray = this.printTextArea.getMouseListeners();
        EventListener[] eventListenerArray = mouseListenerArray;
        int n2 = eventListenerArray.length;
        for (n = 0; n < n2; ++n) {
            MouseListener mouseListener = eventListenerArray[n];
            this.printTextArea.removeMouseListener(mouseListener);
        }
        for (EventListener object2 : eventListenerArray = this.printTextArea.getMouseMotionListeners()) {
            this.printTextArea.removeMouseMotionListener((MouseMotionListener)object2);
        }
        int n3 = (int)paper.getImageableHeight();
        n = (int)paper.getImageableWidth();
        Dimension dimension = new Dimension(n, n3);
        this.setLayout(new BorderLayout(5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.printTextArea);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setBorder(null);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)jScrollPane, "Center");
        this.scrollBar = new JScrollBar(0);
        jPanel.add((Component)this.scrollBar, "South");
        this.scrollBar.setVisible(false);
        this.add((Component)jPanel, "Center");
        jScrollPane.setPreferredSize(dimension);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
        JButton jButton = new JButton(ResourceManager.getString((Object)ResourceKey.OK));
        JButton jButton2 = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        this.add((Component)jPanel2, "South");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintManager.this.dialog.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintManager.this.dialog.dispose();
                PrintManager.this.cancelled = true;
            }
        });
        if (window != null) {
            this.dialog = new JDialog(window, ResourceManager.getString((Object)ResourceKey.PRINT_PREVIEW), Dialog.ModalityType.APPLICATION_MODAL);
        } else {
            this.dialog = new JDialog();
            this.dialog.setTitle(ResourceManager.getString((Object)ResourceKey.PRINT_PREVIEW));
            this.dialog.setModal(true);
        }
        this.dialog.getContentPane().setLayout(new GridLayout(1, 1));
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setResizable(false);
        Dimension dimension2 = this.printTextArea.getSize();
        double d = (double)dimension2.height / (double)n3;
        double d2 = (double)dimension2.width / (double)n;
        this.rows = (int)Math.ceil(d);
        this.cols = (int)Math.ceil(d2);
        if (dimension2.width > this.printTextArea.getParent().getSize().width) {
            this.scrollBar.setVisible(true);
            this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    int n = PrintManager.this.scrollBar.getValue();
                    double d = PrintManager.this.scrollBar.getMaximum() - PrintManager.this.scrollBar.getVisibleAmount();
                    JViewport jViewport = (JViewport)PrintManager.this.printTextArea.getParent();
                    int n2 = jViewport.getSize().width;
                    int n3 = ((PrintManager)PrintManager.this).printTextArea.getSize().width;
                    double d2 = (double)(n3 - n2) / d;
                    PrintManager.this.printTextArea.setLocation((int)(-d2 * (double)n), 0);
                }
            });
        }
    }

    private void showPreview() {
        Window window = this.dialog.getOwner();
        if (window != null && window.isShowing()) {
            DialogUtilities.centerWindow(this.dialog, window);
        } else {
            DialogUtilities.centerOnScreen(this.dialog);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        double d = this.currentPrintJobPaper.getImageableHeight();
        double d2 = this.currentPrintJobPaper.getImageableWidth();
        if (n < this.rows * this.cols) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d3 = (double)(n % this.cols) * d2;
            double d4 = (double)(n / this.cols) * d;
            graphics2D.translate(pageFormat.getImageableX() - d3, pageFormat.getImageableY() - d4);
            this.disableDoubleBuffering(this);
            this.printTextArea.paint(graphics2D);
            this.enableDoubleBuffering(this);
            return 0;
        }
        return 1;
    }

    private void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    private void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }
}

