## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval=FALSE---------------------------------------------------------------
#  devtools::install_github("rfsaldanha/tidyrates")

## -----------------------------------------------------------------------------
library(tidyrates)

## -----------------------------------------------------------------------------
population <- c(230061, 329449, 114920, 39487, 14208, 3052,
72202, 326701, 208667, 83228, 28466, 5375, 15050, 175702,
207081, 117300, 45026, 8660, 2293, 68800, 132424, 98301, 
46075, 9834, 327, 30666, 123419, 149919, 104088, 34392, 
319933, 931318, 786511, 488235, 237863, 61313)

population <- matrix(population, 6, 6, 
dimnames = list(c("Under 20", "20-24", "25-29", "30-34", "35-39",
"40 and over"), c("1", "2", "3", "4", "5+", "Total")))

count <- c(107, 141, 60, 40, 39, 25, 25, 150, 110, 84, 82, 39,
3, 71, 114, 103, 108, 75, 1, 26, 64, 89, 137, 96, 0, 8, 63, 112,
262, 295, 136, 396, 411, 428, 628, 530)
count <- matrix(count, 6, 6, 
dimnames = list(c("Under 20", "20-24", "25-29", "30-34", "35-39",
"40 and over"), c("1", "2", "3", "4", "5+", "Total")))

## -----------------------------------------------------------------------------
population

## -----------------------------------------------------------------------------
count

## -----------------------------------------------------------------------------
fleiss_data

## -----------------------------------------------------------------------------
standard<-apply(population[,-6], 1, mean)
standard

## -----------------------------------------------------------------------------
standard_pop <- tibble::tibble(
    age_group = c("Under 20", "20-24", "25-29", "30-34", "35-39", "40 and over"),
    population = c(63986.6, 186263.6, 157302.2, 97647.0, 47572.6, 12262.6)
  )

## -----------------------------------------------------------------------------
rate_adj_direct(fleiss_data, .std = standard_pop, .keys = "key")

## -----------------------------------------------------------------------------
dth40 <- c(45, 201, 320, 670, 1126, 3160, 9723, 17935,
22179, 13461, 2238)

pop40 <- c(906897, 3794573, 10003544, 10629526, 9465330,
8249558, 7294330, 5022499, 2920220, 1019504, 142532)

## -----------------------------------------------------------------------------
selvin_data_1940

## -----------------------------------------------------------------------------
dth60 <- c(141, 926, 1253, 1080, 1869, 4891, 14956, 30888,
41725, 26501, 5928)

pop60 <- c(1784033, 7065148, 15658730, 10482916, 9939972,
10563872, 9114202, 6850263, 4702482, 1874619, 330915)

## -----------------------------------------------------------------------------
selvin_data_1960

## -----------------------------------------------------------------------------
rate_adj_indirect(selvin_data_1940, selvin_data_1960)

