# Copyright (C) 1997-2000  Adrian Trapletti
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#
# ffnet utility functions
#


as.cl.code <- function (obj, ...) { UseMethod("as.cl.code") }
char.poly.root <- function (obj, ...) { UseMethod("char.poly.root") }

confusion <- function (true, predict)
{
  if (!is.factor(true)) stop ("true is not a factor")
  if (!is.factor(predict)) stop ("predict is not a factor")
  jt <- table(true,predict)
  jn <- dimnames(jt)[[2]]
  jt1 <- jt[jn,]
  res <- list(tbl=jt,error=(1-sum(diag(jt1))/length(true)))
  return (res)
}

as.cl.code.factor <- function (fact)
{
  if (!inherits(fact, "factor")) stop ("method is only for factor objects")
  n <- length (fact)
  lev <- levels (fact)
  nam <- names (fact)
  cd <- matrix (0, n, length(lev))
  idx <- cbind (1:n,as.vector(unclass(fact)))
  cd[idx] <- 1
  dimnames(cd) <- list (nam, lev)
  return (cd)
}

as.factor.cl.code <- function (code, levels)
{
  fact <- factor(levels[apply(code,1,order)[length(levels),]], levels=levels)
  return (fact)
}

char.poly.root.ffnet.ts <- function (nn, eigen = FALSE, abs = TRUE)
{
  if (!inherits(nn, "ffnet.ts")) stop ("method is only for ffnet.ts objects")
  K <- nn$nout
  p <- nn$lag
  A <- matrix(0,K*p,K*p)
  I <- matrix(0,K*(p-1),K*(p-1))
  diag(I) <- 1
  A[-(1:K),-((K*(p-1)+1):(K*p))] <- I
  if (is.null(nn$lagx))
  {
    to <- length(nn$wts)
    from <- to-K*K*p+1
    idx <- from:to
  }
  else
  {
    to <- length(nn$wts)
    from <- to-K*nn$nin+1
    idx <- from:to
    idx <- as.vector(matrix(idx,ncol=K)[1:(K*p),])
  }
  A[1:K,] <- matrix(nn$wts[idx],K,K*p,byrow=T)
  z <- eigen(A)$values
  if (!eigen)
  {
    z <- z[z!=0+0i]
    z <- 1/z
  }
  z.abs <- Mod(z)
  rk <- order(z.abs)
  if (abs)
    return (z.abs[rk])
  else
    return (z[rk])
}




