const char * imem_w32_c_note =
"This file only compiled if WIN32 is defined";

#ifdef WIN32

#ifdef WITH_RCSID
static char * rcsid = "$Id:$";
#endif
/*
 * Portable Memory Management Interface for ANSI C,
 * with Extension for Win32 platforms supporting
 * multiple heaps.
 *
 * Copyright (C) 2000 Federico Spinazzi <fspinazzi@hotmail.com>
 *
 * Free Software License:
 *
 * All rights are reserved by the author, with the following exceptions:
 * Permission is granted to freely reproduce and distribute this software,
 * possibly in exchange for a fee, provided that this copyright notice
 * appears intact.
 *
 * Permission is also granted to adapt this software to produce
 * derivative works, as long as the modified versions carry this copyright
 * notice and additional notices stating that the work has been modified.
 *
 * This source code may be translated into executable form and incorporated
 * into proprietary software; there is no requirement for such software to
 * contain a copyright notice related to this source.
 *
 */
#define IMEM_IMPLEMENTATION
#include <windows.h>
#include "imem_w32.h"

#ifdef WITH_RCSID
static rcsid = "$Id: imem_w32.c 1.2 2000/04/22 14:54:40 federico Exp $";
#endif


/*
 * TODO:
 * - test if HeapDestroy frees all the memory;
 *
 *
 * $Log: imem_w32.c $
 * Revision 1.2  2000/04/22 14:54:40  federico
 * Added a deinit_w32 function
 * Updated for new init prototype
 *
 * Revision 1.1  2000/03/12 00:15:27  federico
 * Initial revision
 *
 *
 */

void *
a_w32_calloc (size_t num, size_t size, void * opaque)
{
	void * p = NULL;

	assert (opaque != NULL);
  p = HeapAlloc ((HANDLE) opaque,
		HEAP_ZERO_MEMORY | HEAP_NO_SERIALIZE, size);
	return p;
}

void *
a_w32_malloc (size_t size, void * opaque)
{
	void * p = NULL;
	assert (opaque != NULL);
  p = HeapAlloc ((HANDLE) opaque, HEAP_NO_SERIALIZE, size);
	return p;
}

void *
a_w32_realloc (void *p, size_t size, void * opaque)
{
	assert (opaque != NULL);
  return HeapReAlloc ((HANDLE) opaque, HEAP_NO_SERIALIZE, p, size);
}

void
a_w32_free (void * p, void * opaque)
{
	assert (opaque != NULL);

	/* TODO: handle p == NULL ? */
	if (p != NULL)
 		HeapFree ((HANDLE)opaque, HEAP_NO_SERIALIZE, p);
}

int
a_deinit_w32 (imem_t *imem)
{
	assert (imem != NULL);
	assert (imem->opaque != NULL);

	HeapDestroy (imem->opaque);

	return 0;
}

int
a_init_w32 (imem_t *imem)
{
	HANDLE hHeap = HeapCreate (HEAP_NO_SERIALIZE, 4096 * 10, 0);
	imem_funcs_t mf = {
		NO_KEEP_AMB | NO_THROW | NO_USE_POOL | WITH_CUSTOM_CLEANUP,
		a_w32_malloc, a_w32_calloc,
		a_w32_realloc, a_w32_free, NULL, a_deinit_w32};


 	if (hHeap == NULL)
		{
			return (!OK);
		}

	mf.opaque = hHeap;
	return a_init (imem, &mf, NULL, IMEM_MAKE_LOG_NAME(w32));
}

#endif /* WIN32 */

