#include <windows.h>
#include <stdio.h>
#include <errno.h>
#include "iuser.h"

/*
 * to use ierror we must define a context ...
 */
iuser_error_context_t my_context =
{ {
	IUSER_DISPATCH_CALLBACK, /* IUSER_SEVERITY_NONE */
	IUSER_DISPATCH_CALLBACK, /* IUSER_SEVERITY_INFO */
  IUSER_DISPATCH_CALLBACK, /* IUSER_SEVERITY_WARN */
	IUSER_DISPATCH_CALLBACK, /* IUSER_SEVERITY_SEVERE */
	IUSER_DISPATCH_EXIT /* IUSER_SEVERITY_FATAL */},
	1, /* override ? */
	NULL /* error context */};


/*
 * ... and a callback function
 */
static int
my_error (iuser_error_t * ierror, int why)
{
	typedef struct my_error_params {
		FILE * _err_stream;
		} err_par;

	static err_par err_pars;

	switch (why)
		{
			case IUSER_ERROR_DEINIT:
				fprintf (stderr, "my_error: Deinitializing !\n");
				fprintf (((err_par *) iuser_error_get_opaque (ierror))->_err_stream,
					"my_error: Deinitializing !\n ***************\n\n");
				fclose (((err_par *) iuser_error_get_opaque (ierror))->_err_stream);
				break;
			case IUSER_ERROR_INIT:
				fprintf (stderr, "my_error: Initializing !\n");
				err_pars._err_stream = fopen ("terror.err", "a");
				iuser_error_set_opaque (ierror, &err_pars);
				break;
			case IUSER_ERROR_HANDLE:
				fprintf (((err_par *) iuser_error_get_opaque (ierror))->_err_stream,
					"my_error: Handling !\n");
				fprintf (((err_par *) iuser_error_get_opaque (ierror))->_err_stream,
					"          %s !\n", ierror->_msg.text);
				MessageBox (NULL, (char_t *) iuser_error_get_message (ierror),
					iuser_error_format_severity (ierror),
					MB_ICONSTOP | MB_OK);
				break;
			case IUSER_ERROR_ABORTING:
			case IUSER_ERROR_EXITING:
				fprintf (stderr, "my_error: Aborting/Exiting !\n");
				MessageBox (NULL, (char *) iuser_error_get_message (ierror),
					iuser_error_format_severity (ierror), MB_ICONSTOP | MB_OK);
				break;
			default:
				break;
		}

	fprintf (stderr, "my_error: error was at line %d of file %s\n",
		ierror->_line, ierror->_file);

	return IUSER_OK;
}

int
main (int argc, char ** argv)
{
	FILE * fp;

	iuser_error_init (g_iuser_error, argv[0], &my_context, my_error, NULL);

	if (argc == 1)
		iuser_error (g_iuser_error, IUSER_SEVERITY_FATAL, -1, __FILE__,
			__LINE__, "You must specify an argument !");

	if ((fp = fopen (argv[1], "r")) == NULL)
		iuser_error (g_iuser_error, IUSER_SEVERITY_WARN, errno,
			__FILE__, __LINE__,
			"it is not possible to open file \"%s\" for reading: (%s)",
			argv[1], strerror(errno));
	else
		fclose (fp);

	iuser_error_deinit (g_iuser_error);

	return EXIT_SUCCESS;
}
