#include "iuser.h"

static char_t *rcsid = "$Id: log.c 1.3 2000-08-25 18:32:50+02 fede Exp fede $";

/*
 * TODO:
 * - clientize with respect to mprintf
 *
 * $Log: log.c $
 * Revision 1.3  2000-08-25 18:32:50+02  fede
 * The callback can't be null
 *
 * Revision 1.2  2000-08-23 18:16:55+02  fede
 * iuser_vmprintf accept an iuser_message_t pointer
 * iuser_log_message_t -> iuser_message_t
 *
 * Revision 1.1  2000-08-21 18:09:08+02  fede
 * Added implementation
 * Added iuser_vmprintf
 *
 *
 */

static iuser_log_t _g_iuser_log;
iuser_log_t const * g_iuser_log = & _g_iuser_log;

const iuser_message_t _IUSER_LOG_MSG_NO_MEMORY =
{AS_TEXT("warning: out of memory while processing a logging request!"), 0};

const iuser_message_t *
IUSER_LOG_MSG_NO_MEMORY = & _IUSER_LOG_MSG_NO_MEMORY;

int
iuser_log_init (iuser_log_t *ilog, iuser_log_callback_t cb,
	char_t * name, void * log_ctx, void * opaque)
{
	int rv = IUSER_OK;

	assert (ilog != NULL);
	assert (cb != NULL);

	ilog->flags = 0;
	ilog->plog = cb;
	ilog->opaque = opaque;
	ilog->log_context = log_ctx;
	ilog->name = name;

	if (cb != NULL)
		rv = ilog->plog (ilog, IUSER_LOG_INIT);

	return rv;
}

void
iuser_log_deinit (iuser_log_t *ilog)
{
	assert (ilog != NULL);
}

void
iuser_log_activate (iuser_log_t * ilog)
{
	assert (ilog != NULL);
	ilog->flags |= IUSER_LOG_IS_ACTIVE;
}

void
iuser_log_deactivate (iuser_log_t *ilog)
{
	assert (ilog != NULL);
	ilog->flags &= ~IUSER_LOG_IS_ACTIVE;
}

int
iuser_log_is_active (iuser_log_t *ilog)
{
	assert (ilog != NULL);
	return ilog->flags & IUSER_LOG_IS_ACTIVE;
}

void
iuser_log_clear (iuser_log_t *ilog)
{
	assert (ilog != NULL);

	if (ilog->plog != NULL)
		ilog->plog (ilog, IUSER_LOG_CLEAR);
}

iuser_log_callback_t
iuser_log_set_callback (iuser_log_t *ilog, iuser_log_callback_t cb)
{
	iuser_log_callback_t prev_cb;

	assert (ilog != NULL);

	prev_cb = ilog->plog;

	if (cb != NULL)
		ilog->plog = cb;

	return prev_cb;
}

iuser_log_callback_t
iuser_log_get_callback (iuser_log_t *ilog)
{
	assert (ilog != NULL);
	return iuser_log_set_callback (ilog, NULL);
}

void *
iuser_log_set_opaque (iuser_log_t * ilog, void * opaque)
{
	void * prev_opaque;
	assert (ilog != NULL);

	prev_opaque = ilog->opaque;

	if (opaque != NULL)
		ilog->opaque = opaque;

	return prev_opaque;
}

void *
iuser_log_get_opaque (iuser_log_t *ilog)
{
	assert (ilog != NULL);

	return iuser_log_set_opaque (ilog, NULL);
}

void *
iuser_log_set_context (iuser_log_t * ilog, void * ctx)
{
	void * prev_ctx;
	assert (ilog != NULL);

	prev_ctx = ilog->log_context;

	if (ctx != NULL)
		ilog->log_context = ctx;

	return prev_ctx;
}

void *
iuser_log_get_context (iuser_log_t *ilog)
{
	assert (ilog != NULL);

	return iuser_log_set_context (ilog, NULL);
}

static int
iuser_log_is_dinamic_message (const iuser_message_t * msg)
{
	return msg->dinamic;
}

void
iuser_log_free_message (iuser_message_t * msg)
{
	if (iuser_log_is_dinamic_message (msg))
		IUSER_FREE ((char_t*) msg->text);
}

char_t *
iuser_log_get_message (iuser_log_t * ilog)
{
	assert (ilog != NULL);
	return ilog->msg.text;
}

char_t *
iuser_log_get_name (iuser_log_t * ilog)
{
	assert (ilog != NULL);
	return ilog->name;
}

char *
iuser_log_get_file (iuser_log_t * ilog)
{
	assert (ilog != NULL);
	return ilog->file;
}

size_t
iuser_log_get_line (iuser_log_t * ilog)
{
	assert (ilog != NULL);
	return ilog->line;
}

#include "mprintf.c"

void
iuser_vmprintf (iuser_message_t * msg, const char * fmt, va_list ap)
{
	assert (msg != NULL);

	/*
	 * sets dinamic to 0/1 if needed
	 */
	msg->dinamic = 0;
	msg->text = vmprintf (NULL, NULL, fmt, ap);

	if (msg->text != NULL)
		{
			msg->dinamic = 1;
		}
	else
		{
			memcpy (msg, IUSER_LOG_MSG_NO_MEMORY,
				sizeof (iuser_message_t));
		}
}

