% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepBF.R
\name{stepBF}
\alias{stepBF}
\title{Identify the optimal number of shifts using Bayes factors}
\usage{
stepBF(BFmat, step.size = 20, expectedNumberOfShifts = 1, inputType = "matrix")
}
\arguments{
\item{BFmat}{square Bayes factor matrix or a named vector of posterior probabilities}

\item{step.size}{how much Bayes factor support is required to accept a more complex model, see Details}

\item{expectedNumberOfShifts}{expected number of shifts under the prior (only needed for \code{inputType = 'postProb'})}

\item{inputType}{describes the input: \code{'matrix'} or \code{'postProb'}}
}
\value{
a list of 3 items: the number of shifts for the best model, the number of shifts for the second best model,
and the Bayes factor support for the best model over the second best.
}
\description{
stepBF is a function to determine the overall best fitting number of shifts 
using Bayes factor evidence.
}
\details{
stepBF takes either a square Bayes factor matrix (such as output by \code{\link{computeBayesFactors}}) or a named 
vector of posterior probabilities. If posterior probabilities are supplied, the model prior
(\code{expectedNumberOfShifts}) must also be provided.
If the input is a Bayes factor matrix, specify \code{inputType = 'matrix'}, otherwise if the input is
a named vector of posterior probabilities, specify \code{inputType = 'postProb'}.

The \code{step.size} argument is how much Bayes factor support is needed to accept a more complex model. 
By default, this value is 1, so any more complex model that has a better Bayes factor than the previous model 
will be accepted. Increasing the step size greatly reduces the Type I error at the cost of inflating Type II 
error. So, with increasing step.size, you will infer fewer shifts.
}
\examples{
data(mcmc.whales)
# remove 10\% burnin
mcmc.whales <- mcmc.whales[floor(0.1 * nrow(mcmc.whales)):nrow(mcmc.whales), ]
# from a square matrix of Bayes factor values (inputType = 'matrix')
bfmat <- computeBayesFactors(mcmc.whales, expectedNumberOfShifts = 1, burnin = 0)
stepBF(bfmat, step.size = 1, inputType = 'matrix')
# or from a vector of posterior probabilities (inputType = 'postProb')
postProb <- table(mcmc.whales$N_shifts) / nrow(mcmc.whales)
stepBF(postProb, step.size = 1, inputType = 'postProb')

}
\references{
\url{http://bamm-project.org}
}
\seealso{
\code{\link{computeBayesFactors}}
}
\author{
Jonathan Mitchell
}
