% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_Lines}
\alias{create_Lines}
\title{Create Lines}
\usage{
create_Lines(
  Input,
  OutputFormat = "ROBJECT",
  OutputName = NULL,
  Buffer = 0,
  Densify = FALSE,
  Clip = FALSE,
  SeparateBuf = TRUE,
  NamesIn = NULL
)
}
\arguments{
\item{Input}{the name of the \code{Input} data as a .csv file or an R dataframe.
If a .csv file is used as input, this file must be in your working directory and its name given in quotes
e.g. "DataFile.csv".

\strong{If \code{NamesIn} is not provided, the columns in the \code{Input} must be in the following order:

Line name, Latitude, Longitude.

If a given line is made of more than two points, the locations of points
must be given in order, from one end of the line to the other.}}

\item{OutputFormat}{can be an R object or an ESRI Shapefile. if \code{OutputFormat} is specified as
"ROBJECT" (the default), a spatial object is created in your R environment.
if \code{OutputFormat} is specified as "SHAPEFILE", an ESRI Shapefile is exported in
your working directory.}

\item{OutputName}{if \code{OutputFormat} is specified as "SHAPEFILE", the name of the output
shapefile in quotes (e.g. "MyLines") must be provided.}

\item{Buffer}{Distance in nautical miles by which to expand the lines. Can be specified for
each line (as a numeric vector).}

\item{Densify}{If set to TRUE, additional points between points of equal latitude are added
prior to projection (see examples).}

\item{Clip}{if set to TRUE, polygon parts (from buffered lines) that fall on land are removed (see \link{Clip2Coast}).}

\item{SeparateBuf}{If set to FALSE when adding a \code{Buffer},
all spatial objects are merged, resulting in a single spatial object.}

\item{NamesIn}{character vector of length 3 specifying the column names of line identifier, Latitude
and Longitude fields in the \code{Input}.

\strong{Names must be given in that order, e.g.:

\code{NamesIn=c('Line ID','Line Latitudes','Line Longitudes')}}.}
}
\value{
Spatial object in your environment or ESRI shapefile in your working directory.
Data within the resulting spatial object contains the data provided in the \code{Input} plus
additional "LengthKm" and "LengthNm" columns which corresponds to the lines lengths,
in kilometers and nautical miles respectively.

To see the data contained in your spatial object, type: \code{View(MyLines@data)}.
}
\description{
Create Lines to display, for example, fishing line locations or tagging data.
}
\examples{
\donttest{


#If your data contains line end locations in separate columns, you may reformat it as follows:

#Example data:
MyData=data.frame(
  Line=c(1,2),
  Lat_Start=c(-60,-65),
  Lon_Start=c(-10,5),
  Lat_End=c(-61,-66),
  Lon_End=c(-2,2)
)

#Reformat to us as input as:
Input=data.frame(
  Line=c(MyData$Line,MyData$Line),
  Lat=c(MyData$Lat_Start,MyData$Lat_End),
  Lon=c(MyData$Lon_Start,MyData$Lon_End)
)

#Create lines and plot them
plot(create_Lines(Input=Input))


#Example 1: Simple and non-densified lines

MyLines=create_Lines(Input=LineData)
plot(MyLines,lwd=2,col=rainbow(length(MyLines)))

#Example 2: Simple and densified lines (note the curvature of the purple line)

MyLines=create_Lines(Input=LineData,Densify=TRUE)
plot(MyLines,lwd=2,col=rainbow(length(MyLines)))

#Example 3: Densified, buffered and clipped lines

MyLines=create_Lines(Input=LineData,Densify=TRUE,Buffer=c(10,40,50,80,100),Clip=TRUE)

plot(MyLines,lwd=2,col=rainbow(length(MyLines)))
plot(Coast[Coast$ID=='All',],col='grey',add=TRUE)

#Example 4: Buffered and grouped lines
MyLines=create_Lines(Input=LineData,Densify=TRUE,Buffer=30,SeparateBuf=FALSE)
plot(MyLines,lwd=2,border='blue')

}

}
\seealso{
\code{\link{create_Points}}, \code{\link{create_Polys}}, \code{\link{create_PolyGrids}},
\code{\link{create_Stations}}, \code{\link{add_RefGrid}}.
}
