% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_iso_polys.R
\name{get_iso_polys}
\alias{get_iso_polys}
\title{Generate Polygons from Isobaths}
\usage{
get_iso_polys(Bathy, Poly = NULL, Depths)
}
\arguments{
\item{Bathy}{bathymetry raster with the appropriate projection, such as
\code{\link[CCAMLRGIS:SmallBathy]{SmallBathy}}.
It is highly recommended to use a raster of higher resolution (see \code{\link{load_Bathy}}).}

\item{Poly}{optional, single polygon inside which isobaths will be computed.
May be created using \code{\link{create_Polys}} or by subsetting an object obtained
using one of the \code{load_} functions (see examples).}

\item{Depths}{numeric, vector of desired isobaths. For example,
\code{Depths=c(-2000,-1000,-500)}.}
}
\value{
Spatial object in your environment. Data within the resulting object contains
a polygon in each row. Columns are as follows: \code{ID} is a unique polygon identifier;
\code{Iso} is an isobath identifier; \code{Min} and \code{Max} is the depth range of isobaths;
\code{Grp} is a group identifier (e.g., a seamount constituted of several isobaths); 
\code{AreaKm2} is the polygon area in square kilometers; \code{Labx} and \code{Laby} can be used
to label groups (see examples).
}
\description{
From an input bathymetry and chosen depths, turns areas between isobaths into polygons.
An input polygon may optionally be given to constrain boundaries.
The accuracy is dependent on the resolution of the bathymetry raster
(see \code{\link{load_Bathy}} to get high resolution data).
}
\examples{

# For more examples, see:
# https://github.com/ccamlr/CCAMLRGIS#46-get_iso_polys


Poly=create_Polys(Input=data.frame(ID=1,Lat=c(-55,-55,-61,-61),Lon=c(-30,-25,-25,-30)))
IsoPols=get_iso_polys(Bathy=SmallBathy,Poly=Poly,Depths=seq(-8000,0,length.out=10))

plot(st_geometry(Poly))
for(i in unique(IsoPols$Iso)){
  plot(st_geometry(IsoPols[IsoPols$Iso==i,]),col=rainbow(9)[i],add=TRUE)
}


}
\seealso{
\code{\link{load_Bathy}}, \code{\link{create_Polys}}, \code{\link{get_depths}}.
}
