% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeriodMean.R
\name{CST_PeriodMean}
\alias{CST_PeriodMean}
\title{Period Mean on 's2dv_cube' objects}
\usage{
CST_PeriodMean(
  data,
  start = NULL,
  end = NULL,
  time_dim = "ftime",
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{An 's2dv_cube' object as provided function \code{CST_Load} in 
package CSTools.}

\item{start}{An optional parameter to defined the initial date of the period 
to select from the data by providing a list of two elements: the initial 
date of the period and the initial month of the period. By default it is set
to NULL and the indicator is computed using all the data provided in 
\code{data}.}

\item{end}{An optional parameter to defined the final date of the period to 
select from the data by providing a list of two elements: the final day of 
the period and the final month of the period. By default it is set to NULL 
and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{A character string indicating the name of the dimension to 
compute the indicator. By default, it is set to 'ftime'. More than one 
dimension name matching the dimensions provided in the object 
\code{data$data} can be specified.}

\item{na.rm}{A logical value indicating whether to ignore NA values (TRUE) or 
not (FALSE).}

\item{ncores}{An integer indicating the number of cores to use in parallel 
computation.}
}
\value{
An 's2dv_cube' object containing the indicator in the element 
 \code{data}.
}
\description{
Period Mean computes the average (mean) of a given variable in a period.
Providing temperature data, two agriculture indices can be obtained by using 
this function:
\itemize{
 \item\code{GST}{Growing Season average Temperature: The average temperature 
                 from April 1st to Octobe 31st}
 \item\code{SprTX}{Spring Average Maximum Temperature: The average daily 
                   maximum temperature from April 1st to May 31st}
}
}
\examples{
exp <- NULL
exp$data <- array(rnorm(45), dim = c(member = 7, ftime = 8))
class(exp) <- 's2dv_cube'
exp$Dates$start <- c(seq(as.Date("01-07-1993", "\%d-\%m-\%Y", tz = 'UTC'),
                   as.Date("01-08-1993","\%d-\%m-\%Y", tz = 'UTC'), "day"),
               seq(as.Date("01-07-1994", "\%d-\%m-\%Y", tz = 'UTC'),
                   as.Date("01-08-1994","\%d-\%m-\%Y", tz = 'UTC'), "day"))
SA <- CST_PeriodMean(exp)

}
