% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTSEA.R
\name{DTSEA}
\alias{DTSEA}
\title{Main function of drug target set enrichment analysis (DTSEA)}
\usage{
DTSEA(
  network,
  disease,
  drugs,
  rwr.pt = 0,
  sampleSize = 101,
  minSize = 1,
  maxSize = Inf,
  nproc = 0,
  eps = 1e-50,
  nPermSimple = 5000,
  gseaParam = 1,
  verbose = TRUE
)
}
\arguments{
\item{network}{The human protein-protein interactome network. It should be or
be preconverted before being inputted in DTSEA.}

\item{disease}{The disease-related nodes.}

\item{drugs}{The drug-target long format dataframe. It includes at least
columns with the drug_id and drug_target.}

\item{rwr.pt}{The random walk p0 vector. Set it to 0 if you wish DTSEA
automatically compute it, or you can provide your predetermined p0 vector.}

\item{sampleSize}{The size of a randomly selected gene collection, where
size = pathwaySize}

\item{minSize}{Minimal set of a drug set to be tested.}

\item{maxSize}{Maximal set of a drug set to be tested.}

\item{nproc}{The CPU workers that fgsea would utilize.}

\item{eps}{The boundary of calculating the p value.}

\item{nPermSimple}{Number of permutations in the simple fgsea implementation
for preliminary estimation of P-values.}

\item{gseaParam}{GSEA parameter value, all gene-level statistics are raised
to the power of 'gseaParam' before calculating of GSEA enrichment scores.}

\item{verbose}{Show the messages}
}
\value{
The resulting dataframe consists of `drug_id`, `pval`, `padj`,
`log2err`, `ES`, `NES`, `size`, and `leadingEdge`.
}
\description{
The DTSEA function determines whether a drug is potent for a
specific disease by the proximity between its targets and the disease-related
genes.
}
\examples{
library(DTSEA)

# Load the data
data("example_disease_list", package = "DTSEA")
data("example_drug_target_list", package = "DTSEA")
data("example_ppi", package = "DTSEA")

# Run the DTSEA
result <- DTSEA(
  network = example_ppi,
  disease = example_disease_list,
  drugs = example_drug_target_list
)

## Or you can utilize the multi-core advantages by enable nproc parameters
## on non-Windows operating systems.
# result <- DTSEA(
#   network = example_ppi,
#   disease = example_disease_list,
#   drugs = example_drug_target_list,
#   nproc = 10
# )

# We can sort the result dataframe by normalized enrichment scores (NES) and
# extract the significantly NES > 0 items.
library(dplyr)
result \%>\%
  arrange(desc(NES)) \%>\%
  filter(NES > 0 & pval < .05)

}
