% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynComm.R
\docType{methods}
\name{vertexCount}
\alias{vertexCount}
\alias{DynComm.vertexCount}
\alias{DynComm.nodesCount}
\title{vertexCount()}
\usage{
DynComm.vertexCount(dyncomm)
DynComm.nodesCount(dyncomm)
}
\arguments{
\item{dyncomm}{A DynComm object, if not using the inline version of the 
function call}
}
\value{
an unsigned integer with the number of vertices in the graph
}
\description{
Get the total number of vertices from the selected post processing
algorithm or the main algorithm, after the last iteration.
}
\details{
It can be useful since vertices can be added, if an edge being added has vertices 
that do not exist in the graph, or removed, if they are not part of any edge after 
removing an edge.
}
\examples{
library(DynComm)

Parameters<-matrix(c("e","0.1","w", "FALSE"),ncol=2, byrow=TRUE)
dc<-DynComm(ALGORITHM$LOUVAIN,CRITERION$MODULARITY,Parameters)
dc$addRemoveEdges(
 matrix(
   c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,12,13,1,1,1,2,2,2,18,12,19,20,2,3,11,12,4,9,5,9,22)
      ,ncol=2)
)

dc$communities()
dc$communityVertexCount(12)

}
\seealso{
\code{\link{DynComm}} , \code{\link{postProcess}}
}
\author{
poltergeist0
}
