% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modMedStr1.R
\name{run_MedStrI}
\alias{run_MedStrI}
\title{Run Str Data I}
\usage{
run_MedStrI(
  mar.path,
  mar.columns = list(),
  medGivenReq = FALSE,
  flow.path = NULL,
  flow.columns = list(),
  medchk.path = NULL,
  demo.list = NULL,
  demo.columns = list(),
  missing.wgt.path = NULL,
  wgt.columns = list(),
  check.path = NULL,
  failflow_fn = "FailFlow",
  failnounit_fn = "NoUnit",
  failunit_fn = "Unit",
  failnowgt_fn = "NoWgt",
  censor_date_fn = "CensorTime",
  infusion.unit = "mcg/kg/hr",
  bolus.unit = "mcg",
  bol.rate.thresh = Inf,
  rateunit = "mcg/hr",
  ratewgtunit = "mcg/kg/hr",
  weightunit = "kg",
  drugname = NULL
)
}
\arguments{
\item{mar.path}{filename of MAR data (CSV, RData, RDS), or data.frame}

\item{mar.columns}{a named list that should specify columns in MAR data; \sQuote{id},
\sQuote{datetime} and \sQuote{dose} are required. \sQuote{drug}, \sQuote{weight},
\sQuote{given} may also be specified. \sQuote{datetime} is date and time for data
measurement, which can refer to a single date-time variable (datetime = \sQuote{date_time})
or two variables holding date and time separately (e.g., datetime = c(\sQuote{Date}, \sQuote{Time})).
\sQuote{dose} can also be given as a single variable or two variables. If given as a single column,
the column's values should contain dose and units such as \sQuote{25 mcg}. If given as
two column names, the dose column should come before the unit column
(e.g., dose = c(\sQuote{doseamt}, \sQuote{unit})). \sQuote{drug} can provide list of acceptable drug names.
If \sQuote{drug} is present, the \sQuote{medchk.path} argument should also be provided.
The \sQuote{given} is a variable that flags whether the medication (inpatient) was given. When it is given, 
values shoule be \dQuote{Given}; should be used in conjunction with the \sQuote{medGivenReq} argument.}

\item{medGivenReq}{if TRUE, values in \sQuote{given} column in MAR data should equal \dQuote{Given}; 
if this is FALSE (the default), NA values are also acceptable.}

\item{flow.path}{filename of flow data (CSV, RData, RDS), or data.frame}

\item{flow.columns}{a named list that should specify columns in flow data; \sQuote{id},
\sQuote{datetime}, \sQuote{finalunits}, \sQuote{unit}, \sQuote{rate}, \sQuote{weight}
are required. \sQuote{idvisit} may also be specified. \sQuote{datetime} is date and time
for data measurement, which can refer to a single date-time variable
(datetime = \sQuote{date_time}) or two variables holding date and time separately
(e.g., datetime = c(\sQuote{Date}, \sQuote{Time})).}

\item{medchk.path}{filename containing data set (CSV, RData, RDS), or data.frame; should have
the column \sQuote{medname} with list of acceptable drug names (e.g., brand and generic name, abbreviations)
to subset drugs of interest using \sQuote{drug} column in MAR data. This argument can be used when MAR data 
contains different drugs that should be excluded.}

\item{demo.list}{demographic information; if available, the output from `run_Demo` or 
a correctly formatted data.frame, which can be used to impute weight when missing}

\item{demo.columns}{a named list that should specify columns in demographic data; \sQuote{id},
\sQuote{datetime}, and \sQuote{weight} are required. \sQuote{datetime} is the date
and time when the demographic data were obtained, which can refer to a single date-time
variable (datetime = \sQuote{date_time}) or two variables holding date and time separately
(e.g., datetime = c(\sQuote{Date}, \sQuote{Time})).}

\item{missing.wgt.path}{filename containing additional weight data (CSV, RData, RDS), or data.frame. 
The variables in this file should be defined in the \sQuote{wgt.columns} argument.}

\item{wgt.columns}{a named list that should specify columns in additional weight data; \sQuote{id},
\sQuote{datetime}, and \sQuote{weight} are required. \sQuote{datetime} is date
and time for weight measurement, which can refer to a single date-time variable
(datetime = \sQuote{date_time}) or two variables holding date and time separately
(e.g., datetime = c(\sQuote{Date}, \sQuote{Time})).}

\item{check.path}{path to \sQuote{check} directory, where check files are
created. The default (NULL) will not produce any check files.}

\item{failflow_fn}{filename for duplicate flow data with rate zero}

\item{failnounit_fn}{filename for MAR data with missing unit}

\item{failunit_fn}{filename for MAR data with invalid unit}

\item{failnowgt_fn}{filename for infusion data with missing weight where unit
indicates weight is required}

\item{censor_date_fn}{filename containing censor times created with invalid dose data}

\item{infusion.unit}{acceptable unit for infusion data}

\item{bolus.unit}{acceptable unit for bolus data}

\item{bol.rate.thresh}{upper limit for bolus rate; values above this are invalid}

\item{rateunit}{acceptable unit for hourly rate; defaults to \sQuote{mcg/hr}}

\item{ratewgtunit}{acceptable unit for hourly rate by weight; defaults to \sQuote{mcg/kg/hr}}

\item{weightunit}{acceptable unit for weight; defaults to \sQuote{kg}}

\item{drugname}{drug of interest, included in filename of check files. The default (NULL)
will produce filenames without drugname included.}
}
\value{
structured data set
}
\description{
This module will load and modify structured intravenous (IV) infusion and 
bolus medication data.
}
\details{
See EHR Vignette for Structured Data.
}
\examples{
# flow data for 'Fakedrug1'
flow <- data.frame(mod_id=c(1,1,2,2,2),
                   mod_id_visit=c(46723,46723,84935,84935,84935),
                   record.date=c("07/05/2019 5:25","07/05/2019 6:01",
                                 "09/04/2020 3:21", "09/04/2020 4:39",
                                 "09/04/2020 5:32"),
                   Final.Weight=c(6.75,6.75,4.5,4.5,4.5),
                   Final.Rate=c(rep("1 mcg/kg/hr",2),
                                rep("0.5 mcg/kg/hr",3)),
                   Final.Units=c("3.375","6.5",
                                 "2.25","2.25","2.25"))
flow[,'Perform.Date'] <- pkdata::parse_dates(flow[,'record.date'])
flow[,'unit'] <- sub('.*[ ]', '', flow[,'Final.Rate'])
flow[,'rate'] <- as.numeric(sub('([0-9.]+).*', '\\\\1', flow[,'Final.Rate']))

# mar data for 4 fake drugs
mar <- data.frame(mod_id=rep(1,5),
                  Date=rep("2019-07-05",5),
                  Time=c("07:12","07:31","08:47","09:16","10:22"),
                  `med:mDrug`=c("Fakedrug2","Fakedrug1","Fakedrug2",
                                "Fakedrug3","Fakedrug4"),
                  `med:dosage`=c("30 mg","0.5 mcg","1 mg",
                                 "20 mg","3 mcg/kg/min"),
                  `med:route`=rep("IV",5),
                  `med:given`=rep("Given",5),
                  check.names=FALSE)

# medcheck file for drug of interest ('Fakedrug1')
medcheck <- data.frame(medname="Fakedrug1",freq=4672)

run_MedStrI(mar.path = mar,
            mar.columns = list(id = 'mod_id', datetime = c('Date','Time'),
                               dose = 'med:dosage', drug = 'med:mDrug', given = 'med:given'),
            flow.path = flow,
            flow.columns = list(id = 'mod_id', datetime = 'Perform.Date',
                                finalunits = 'Final.Units', unit = 'unit',
                                rate = 'rate', weight = 'Final.Weight'),
            medchk.path = medcheck,
            check.path = tempdir(),
            drugname = 'fakedrg1')

}
