% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EVI.graphs.R
\name{evi.graphs}
\alias{evi.graphs}
\title{Epidemic Volatility Index Graphs}
\usage{
evi.graphs(EVI_output, graph = c("EVI"), ln = TRUE, type = "p")
}
\arguments{
\item{EVI_output}{output of the \code{\link[EVI:deviant]{deviant()}} function}

\item{graph}{Type of graph to be plotted. Options: "EVI", "PPV", "NPV". "EVI" (the default) is giving a plot of the confirmed cases, with red dots corresponding to time points that an early warning was issued and grey dots corresponding to time points without an early warning indication. "PPV" is giving a plot of the confirmed cases with colored dots corresponding to time points with an early warning. Color intensity is increasing with higher PPV. "NPV" is giving a plot of the confirmed cases with colored dots corresponding to time points without an early warning. Color intensity is increasing with higher NPV.}

\item{ln}{TRUE or FALSE; If TRUE (the default) the output of the graph will be presented on the logarithmic scale. IF FALSE the output data will be presented on the original scale.}

\item{type}{By default, points are plotted on EVI graphs. In cases where, changes are very sudden or data sparsely available, type="l" introduces lines on top of points for the "EVI" type of graph.}
}
\value{
Three types of plots are generated:
(i) A plot of the confirmed cases with red dots corresponding to time points that an early warning was issued and grey dots corresponding to time points without an early warning indication.
(ii) A plot of the confirmed cases with colored dots corresponding to time points with an early warning. Color intensity is increasing with higher positive predictive value (PPV).
(iii) A plot of the confirmed cases with colored dots corresponding to time points without an early warning. Color intensity is increasing with higher negative predictive value (NPV).

An EVI_output is required as input, derived from the \code{\link[EVI:deviant]{deviant()}} function.
}
\description{
This function  produces  plots of the time series data with the EVI predictions.
}
\examples{
     \dontrun{
        # Epidemic Volatility Index (EVI) Explained:
	       vignette('EVI', package='EVI')
	       
       # For information on how to cite EVI:
       citation('EVI')
    }

}
\references{
Kostoulas, P., Meletis, E., Pateras, K. et al. The epidemic volatility index, a novel early warning tool for identifying new waves in an epidemic. Sci Rep 11, 23775 (2021). \doi{10.1038/s41598-021-02622-3}
}
