% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitlinear.R
\name{fitlinear}
\alias{fitlinear}
\title{Determine Linear Regression Coefficients from Dose-Effect Data}
\usage{
fitlinear(DEdata, constr = c(1e-04, 0.9999))
}
\arguments{
\item{DEdata}{A data frame of dose-effect data (typically, the output from
\code{\link{dataprep}}) containing at least three variables:
log10dose, bitpfx, and LWkeep.}

\item{constr}{A numeric vector of length two, indicating the constraints
(see \code{\link{constrain}}) applied to the proportional effects,
default c(0.0001, 0.9999).}
}
\value{
A numeric vector of length two, the estimated intercept and slope.
}
\description{
Determine coefficients (intercept and slope) from dose-effect data using
  simple linear regression on the log10 dose vs. probit effect scale.
}
\examples{
conc <- c(0.0625, 0.125, 0.25, 0.5, 1)
numtested <- rep(8, 5)
nalive <- c(1, 4, 4, 7, 8)
mydat <- dataprep(dose=conc, ntot=numtested, nfx=nalive)
fitlinear(mydat)
}

