% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_vegperiod.R
\name{calc_vegperiod}
\alias{calc_vegperiod}
\title{Calculate the dates of budburst and beginning of leaf fall}
\usage{
calc_vegperiod(
  budburst_method,
  leaffall_method,
  dates = NULL,
  tavg = NULL,
  out_yrs = NULL,
  budburstdoy.fixed = 121,
  leaffalldoy.fixed = 279,
  ...
)
}
\arguments{
\item{budburst_method}{name of model for estimating budburst day of year.
Either 'fixed' or one of the values accepted by the 'start.method'-argument
of the function \code{\link[vegperiod]{vegperiod}}.}

\item{leaffall_method}{name of model for estimating day of year when leaffall
begin. Either 'fixed' or one of the values accepted by the
'end.method'-argument of the function \code{\link[vegperiod]{vegperiod}}.}

\item{dates}{date vector passed to \code{\link[vegperiod]{vegperiod}},
ignored if both leaffall_method and budburst_method = 'fixed'}

\item{tavg}{vector of daily mean air temperature (deg C) passed to
\code{\link[vegperiod]{vegperiod}}, ignored if \code{leaffall_method =
'fixed'} and \code{budburst_method = 'fixed'}.}

\item{out_yrs}{integer vector of the years to be returned. If not
specified, values for the years in \code{dates} will be returned.}

\item{budburstdoy.fixed}{vector of values to be returned if
\code{budburst_method = 'fixed'}.}

\item{leaffalldoy.fixed}{vector of values to be returned if
\code{leaffall_method = 'fixed'}.}

\item{...}{additional argument passed to \code{\link[vegperiod]{vegperiod}}.}
}
\value{
a data.frame with columns \code{year}, \code{start}, \code{end}. If
  \code{budburst_method = 'fixed'} or \code{leaffall_method = 'fixed'},
  \code{start} and \code{end} contain the values specified in
  \code{budburstdoy.fixed} and \code{leaffalldoy.fixed} respectively.
}
\description{
Wrapper for \code{\link[vegperiod]{vegperiod}}
}
\examples{
# fixed budburst and leaffall doy
calc_vegperiod(out_yrs = 2001:2010,
               budburst_method = "fixed",
               leaffall_method = "fixed",
               budburstdoy.fixed = floor(runif(10, 120,130)),
               leaffalldoy.fixed = floor(runif(2, 260,280)))

# dynamic budburst and leaffall using air temperature
data(slb1_meteo)

calc_vegperiod(budburst_method = "Menzel",
               leaffall_method = "fixed",
               leaffalldoy.fixed = 280,
               dates = slb1_meteo$dates,
               tavg = slb1_meteo$tmean,
               species = "Fagus sylvatica",
               est.prev = 3)

calc_vegperiod(budburst_method = "Menzel",
               leaffall_method = "ETCCDI",
               dates = slb1_meteo$dates,
               tavg = slb1_meteo$tmean,
               species = "Quercus robur",
               est.prev = 3)
}
