% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{compute_exome_coverage}
\alias{compute_exome_coverage}
\title{Compute exome coverage from a region file}
\usage{
compute_exome_coverage(targets_bed_file, out_file = NULL)
}
\arguments{
\item{targets_bed_file}{Path to a bed file with exome target regions}

\item{out_file}{A file name to which the number of covered bases will be written, instead of returning the value}
}
\value{
An integer value of the sum of the length of the covered regions
}
\description{
This function will take a bed file, and return the sum of the lengths of unique regions
}
\examples{
library(MAFDash)
bedFile <- system.file("extdata", "test.bed", package = "MAFDash")
coverage<-compute_exome_coverage(bedFile)
}
\author{
Mayank Tandon, Ashish Jain
}
