% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univDecomp.R
\name{splineBasis2D}
\alias{splineBasis2D}
\alias{splineBasis2Dpen}
\title{Calculate a spline basis representation for functional data on 
two-dimensional domains}
\usage{
splineBasis2D(funDataObject, bs = "ps", m = NA, k = -1)

splineBasis2Dpen(funDataObject, bs = "ps", m = NA, k = -1,
  parallel = FALSE)
}
\arguments{
\item{funDataObject}{An object of class \code{\link[funData]{funData}} 
containing the observed functional data samples and for which the basis 
representation is calculated.}

\item{bs}{A vector of character strings (or a single character string), 
specifying the type of basis functions to be used. Defaults to \code{"ps"} 
(P-spline functions). Please refer to \code{\link[mgcv]{te}} for a list of 
possible basis functions.}

\item{m}{A numeric vector (or a single number), the order of the spline 
basis. Defaults to \code{NA}, i.e. the order is chosen automatically.  See 
\code{\link[mgcv]{s}} for details.}

\item{k}{An numeric vector (or a single number), the number of basis 
functions used.  Defaults to \code{-1}, i.e. the number of basis functions 
is chosen automatically.   See  \code{\link[mgcv]{s}} for details.}

\item{parallel}{Logical (only for function \code{splineBasis2Dpen}). If 
\code{TRUE}, the coefficients for the basis functions are calculated in 
parallel. The implementation is based on the \code{\link[foreach]{foreach}}
function and requires a parallel backend that must be registered before. 
See \code{\link[foreach]{foreach}} for details.}
}
\value{
\item{scores}{A matrix of scores (coefficients) with dimension 
  \code{N x K}, reflecting the weights for each basis function in each 
  observation, where \code{K} is the total number of basis functions used.} 
  \item{B}{A matrix containing the scalar product of all pairs of basis 
  functions.} \item{ortho}{Logical, set to \code{FALSE}, as basis functions 
  are not orthonormal.} \item{functions}{\code{NULL}, as basis functions are 
  known.} \item{settings}{A list with entries \code{bs}, \code{m} and 
  \code{k}, giving the actual parameters used for generating the spline basis
  functions.}
}
\description{
These functions calculate a penalized or unpenalized tensor product spline 
basis representation for functional data on two-dimensional domains based on 
the \code{\link[mgcv]{gam}}/\code{\link[mgcv]{bam}} functions in the
\pkg{mgcv} package. See Details.
}
\details{
If the basis representation is calculated without penalization 
(\code{splineBasis2D}), the coefficients are computed using the 
\code{\link[mgcv]{gam}} function from the \pkg{mgcv} package. In the case of 
penalization (\code{splineBasis2Dpen}), the function \code{\link[mgcv]{bam}}
(for large GAMs) is used instead.
}
\examples{
# simulate image data for N = 100 observations
N <- 100
b1 <- eFun(seq(0,1,0.01), M = 7, type = "Poly")
b2 <- eFun(seq(-pi, pi, 0.03), M = 8, type = "Fourier")
b <- tensorProduct(b1,b2) # 2D basis functions
scores <- matrix(rnorm(N*56), nrow = N)

# calculate observations (= linear combination of basis functions)
dat <- MFPCA:::expandBasisFunction(scores = scores, functions = b)

# calculate 2D spline basis decomposition (needs some time)
\donttest{
# use 5 basis functions in each direction
dataDec <- MFPCA:::splineBasis2D(dat, k = c(5,5)) 
}

# add some noise to the data
noisyDat <- addError(dat, sd = 0.5)

# calculate 2D spline basis decomposition with penalization (needs A LOT more time)
\donttest{
# use 5 basis functions in each direction
noisyDataDec <- MFPCA:::splineBasis2Dpen(noisyDat, k = c(5,5)) 
}
}
\seealso{
\code{\link{univDecomp}}, \code{\link{splineBasis1D}}, 
  \code{\link[mgcv]{gam}}, \code{\link[mgcv]{bam}}, 
  \code{\link[foreach]{foreach}}
}
\keyword{internal}
