% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{ttest_surrogates}
\alias{ttest_surrogates}
\title{ttest_surrogates}
\usage{
ttest_surrogates(surrogates, bin_phenotypes)
}
\arguments{
\item{surrogates}{numeric data.frame containing the surrogate values by Bizzarri et al.}

\item{bin_phenotypes}{numeric data.frame with the binarized phenotypes output of binarize_all_pheno}
}
\value{
plotly image with all the ROCs for all the available clinical variables
}
\description{
Function that calculates a t-test and a plotly image of the selected surrogates
}
\details{
Barplot and T-test indicating if the surrogate variables could split accordingly the real value of the binary clinical variables.
}
\examples{
require(pROC)
require(plotly)
require(MiMIR)
require(foreach)

#load the dataset
m <- synthetic_metabolic_dataset
p <- synthetic_phenotypic_dataset

#Calculating the binarized surrogates
b_p<-binarize_all_pheno(p)
#Apply a surrogate models and plot the ROC curve
surr<-calculate_surrogate_scores(met=m, pheno=p, MiMIR::PARAM_surrogates, bin_names=colnames(b_p))
ttest_surrogates(surr$surrogates, b_p)

}
