% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankings.R
\name{rankings}
\alias{rankings}
\alias{as.rankings}
\alias{as.rankings.default}
\alias{as.rankings.matrix}
\alias{[.rankings}
\alias{format.rankings}
\alias{rbind.rankings}
\title{Rankings Object}
\usage{
rankings(data, id, item, rank, verbose = TRUE, ...)

as.rankings(x, input = c("ranking", "ordering"), labels = NULL,
  verbose = TRUE, ...)

\method{as.rankings}{default}(x, input = c("ranking", "ordering"),
  labels = NULL, verbose = TRUE, ...)

\method{as.rankings}{matrix}(x, input = c("ranking", "ordering"),
  labels = NULL, verbose = TRUE, ...)

\method{[}{rankings}(x, i, j, ..., drop = TRUE, as.rankings = TRUE)

\method{format}{rankings}(x, width = 40L, ...)

\method{rbind}{rankings}(..., labels = NULL)
}
\arguments{
\item{data}{a data frame with columns specified by \code{id}, \code{item} and
\code{rank}.}

\item{id}{an index of \code{data} specifying the column containing ranking
IDs.}

\item{item}{an index of \code{data} specifying the column containing item
IDs,}

\item{rank}{an index of \code{data} specifying the column containing item
ranks.}

\item{verbose}{logical; if \code{TRUE} print messages when changes are made
to rankings data.}

\item{...}{further arguments passed to/from methods.}

\item{x}{for \code{as.rankings}, a matrix with one column per item and one
row per ranking, or an object that can be coerced to such as matrix; for
\code{[} and \code{format}, a \code{"rankings"} object.}

\item{input}{for \code{as.rankings}, whether each row in the input matrix
contains a numeric \code{"ranking"} (dense, standard/modified competition or
fractional ranking) or an \code{"ordering"}, i.e. the items ordered by rank.}

\item{labels}{for \code{input = "ordering"} an optional vector of labels for
the items. If \code{NULL}, the items will be labelled by the sorted unique
values of \code{x}.}

\item{i}{indices specifying rankings to extract, as for \code{\link{[}}.}

\item{j}{indices specifying items to extract, as for \code{\link{[}}.}

\item{drop}{if \code{TRUE} return single row/column matrices as a vector.}

\item{as.rankings}{if \code{TRUE} return a rankings object, otherwise return
a matrix/vector.}

\item{width}{the width in number of characters to format each ranking -
rankings that are too wide will be truncated.}
}
\value{
a \code{"rankings"} object, which is a matrix of dense rankings
with one attribute \code{omit} the indices of any rankings that were
omitted due to insufficient data (less than two non-missing ranks).
}
\description{
Create a \code{"rankings"} object from data or convert a matrix of rankings
or ordered items to a \code{"rankings"} object.
}
\details{
Each ranking in the input data will be converted to a dense ranking, which
rank items from 1 (first place) to \eqn{n_r} (last place). Items not ranked
should have a rank of 0. Tied items are given the same rank with no rank
skipped. For example {1, 0, 2, 1}, ranks the first and fourth items in
first place and the third item in second place; the second item is unranked.

Rankings with less than 2 items are dropped.

The method for \code{[} will return a reduced rankings object by default,
recoding and dropping invalid rankings as necessary. To extract rows
and/or columns of the rankings as a matrix or vector,
set \code{as.rankings = FALSE}, see examples.
}
\examples{
# create rankings from data in long form
x <- data.frame(ranking = c(rep(1:4, each = 4), 5, 5, 5),
                letter = c(LETTERS[c(1:3, 3, 1:4, 2:5, 1:2, 1)], NA,
                           LETTERS[3:5]),
                rank = c(4:1, rep(NA, 4), 3:4, NA, NA, 1, 3, 4, 2, 2, 2, 3))
# ranking 1 has different rank for same item, but order of items unambiguous
# all ranks are missing in ranking 2
# some ranks are missing in ranking 3
# ranking 4 has inconsistent ranks for two items and a rank with missing item
# ranking 5 is fine - an example of a tie
split(x, x$ranking)
# fix issues when creating rankings object
rankings(x, id = "ranking", item = "letter", rank = "rank")

# convert existing matrix of rankings
R <- matrix(c(1, 2, 0, 0,
              4, 1, 2, 3,
              2, 1, 1, 1,
              1, 2, 3, 0,
              2, 1, 1, 0,
              1, 0, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) <- c("apple", "banana", "orange", "pear")
R <- as.rankings(R)
# first three rankings
R[1:3,]
# exclude pear from the rankings
R[, -4]
# extract rankings 2 and 3 as numeric matrix
R[2:3, , as.rankings = FALSE]
# same as
unclass(R)[2:3,]
# extract rankings for item 1 as a vector
R[,1, as.rankings = FALSE]

}
