% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete.R
\name{complete}
\alias{complete}
\title{Complete Orderings with the Missing Redundant Rank}
\usage{
complete(orderings, items)
}
\arguments{
\item{orderings}{A data frame of orderings with one rank missing.}

\item{items}{A vector of item names.}
}
\value{
A vector of the missing items, which will be a list if there are
any ties.
}
\description{
Given orderings with one rank missing, complete the ordering by assigning
the remaining item(s) to the final rank.
}
\examples{
# Orderings of 3 items, when only the best and worst are recorded
orderings <- data.frame(best = c("A", "B", "A"),
                        worst = c("C", "C", NA))
orderings$middle <- complete(orderings, items = c("A", "B", "C"))
}
