/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ColorChooser;
import ij.gui.ImageCanvas;
import ij.gui.Toolbar;
import ij.plugin.ColorGenerator;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;

class ColorCanvas
extends ImageCanvas {
    Vector colors;
    boolean background = false;
    long mouseDownTime;

    public ColorCanvas(ImagePlus imp) {
        super(imp);
    }

    public void mousePressed(MouseEvent e) {
        ImageProcessor ip = this.imp.getProcessor();
        ip.setLineWidth(1);
        if (Toolbar.getToolId() == 13) {
            IJ.setTool(0);
        }
        Rectangle flipperRect = new Rectangle(86, 268, 18, 18);
        Rectangle resetRect = new Rectangle(86, 294, 18, 18);
        Rectangle foreground1Rect = new Rectangle(9, 266, 45, 10);
        Rectangle foreground2Rect = new Rectangle(9, 276, 23, 25);
        Rectangle background1Rect = new Rectangle(33, 302, 45, 10);
        Rectangle background2Rect = new Rectangle(56, 277, 23, 25);
        int x = this.offScreenX(e.getX());
        int y = this.offScreenY(e.getY());
        long difference = System.currentTimeMillis() - this.mouseDownTime;
        boolean doubleClick = difference <= 250L;
        this.mouseDownTime = System.currentTimeMillis();
        if (flipperRect.contains(x, y)) {
            Color c = Toolbar.getBackgroundColor();
            Toolbar.setBackgroundColor(Toolbar.getForegroundColor());
            Toolbar.setForegroundColor(c);
        } else if (resetRect.contains(x, y)) {
            Toolbar.setForegroundColor(new Color(0));
            Toolbar.setBackgroundColor(new Color(0xFFFFFF));
        } else if (background1Rect.contains(x, y) || background2Rect.contains(x, y)) {
            this.background = true;
            if (doubleClick) {
                this.editColor();
            }
            ((ColorGenerator)ip).refreshForeground();
            ((ColorGenerator)ip).refreshBackground();
        } else if (foreground1Rect.contains(x, y) || foreground2Rect.contains(x, y)) {
            this.background = false;
            if (doubleClick) {
                this.editColor();
            }
            ((ColorGenerator)ip).refreshBackground();
            ((ColorGenerator)ip).refreshForeground();
        } else if (doubleClick) {
            this.editColor();
        } else {
            this.setDrawingColor(this.offScreenX(e.getX()), this.offScreenY(e.getY()), this.background);
        }
        if (ip instanceof ColorGenerator) {
            if (this.background) {
                ((ColorGenerator)ip).refreshForeground();
                ((ColorGenerator)ip).refreshBackground();
            } else {
                ((ColorGenerator)ip).refreshBackground();
                ((ColorGenerator)ip).refreshForeground();
            }
        }
    }

    void editColor() {
        Color c = this.background ? Toolbar.getBackgroundColor() : Toolbar.getForegroundColor();
        ColorChooser cc = new ColorChooser((this.background ? "Background" : "Foreground") + " Color", c, false);
        c = cc.getColor();
        if (this.background) {
            Toolbar.setBackgroundColor(c);
        } else {
            Toolbar.setForegroundColor(c);
        }
    }

    public void refreshColors() {
        ImageProcessor ip = this.imp.getProcessor();
        ((ColorGenerator)ip).refreshBackground();
        ((ColorGenerator)ip).refreshForeground();
    }
}

