/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.text.TextPanel;
import ij.util.Java2;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

class TextCanvas
extends Canvas {
    TextPanel tp;
    Font fFont;
    FontMetrics fMetrics;
    Graphics gImage;
    Image iImage;
    boolean antialiased;

    TextCanvas(TextPanel textPanel) {
        this.tp = textPanel;
        this.addMouseListener(textPanel);
        this.addMouseMotionListener(textPanel);
        this.addKeyListener(textPanel);
        this.addMouseWheelListener(textPanel);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.tp.adjustVScroll();
        this.tp.adjustHScroll();
        this.iImage = null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        if (this.tp == null || graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        graphics.setColor(Color.lightGray);
        if (this.iImage == null) {
            this.makeImage(n2, n3);
        }
        if (this.tp.iRowHeight == 0 || this.tp.iColWidth[0] == 0 && this.tp.iRowCount > 0) {
            this.tp.iRowHeight = this.fMetrics.getHeight() + 2;
            for (n = 0; n < this.tp.iColCount; ++n) {
                this.calcAutoWidth(n);
            }
            this.tp.adjustHScroll();
            this.tp.adjustVScroll();
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, n2, n3);
        if (this.tp.headings) {
            this.drawColumnLabels(n2);
        }
        int n4 = 0;
        for (n = this.tp.iRowHeight + 1 - this.tp.iY; n < this.tp.iRowHeight + 1; n += this.tp.iRowHeight) {
            ++n4;
        }
        this.tp.iFirstRow = n4;
        for (n = this.tp.iRowHeight + 1; n < n3 && n4 < this.tp.iRowCount; ++n4, n += this.tp.iRowHeight) {
            int n5 = -this.tp.iX;
            for (int i = 0; i < this.tp.iColCount; ++i) {
                int n6 = this.tp.iColWidth[i];
                Color color = Color.white;
                Color color2 = Color.black;
                if (n4 >= this.tp.selStart && n4 <= this.tp.selEnd) {
                    int n7 = n6;
                    if (this.tp.iColCount == 1) {
                        n7 = n2;
                    }
                    color = Color.black;
                    color2 = Color.white;
                    this.gImage.setColor(color);
                    this.gImage.fillRect(n5, n, n7 - 1, this.tp.iRowHeight);
                }
                this.gImage.setColor(color2);
                char[] cArray = this.getChars(i, n4);
                if (cArray != null) {
                    this.gImage.drawChars(cArray, 0, cArray.length, n5 + 2, n + this.tp.iRowHeight - 5);
                }
                n5 += n6;
            }
        }
        if (this.iImage != null) {
            graphics.drawImage(this.iImage, 0, 0, null);
        }
    }

    void makeImage(int n, int n2) {
        this.iImage = this.createImage(n, n2);
        if (this.gImage != null) {
            this.gImage.dispose();
        }
        this.gImage = this.iImage.getGraphics();
        this.gImage.setFont(this.fFont);
        Java2.setAntialiasedText(this.gImage, this.antialiased);
        if (this.fMetrics == null) {
            this.fMetrics = this.gImage.getFontMetrics();
        }
    }

    void drawColumnLabels(int n) {
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(0, this.tp.iRowHeight, n, this.tp.iRowHeight);
        int n2 = -this.tp.iX;
        for (int i = 0; i < this.tp.iColCount; ++i) {
            int n3 = this.tp.iColWidth[i];
            this.gImage.setColor(Color.lightGray);
            this.gImage.fillRect(n2 + 1, 0, n3, this.tp.iRowHeight);
            this.gImage.setColor(Color.black);
            if (this.tp.sColHead[i] != null) {
                this.gImage.drawString(this.tp.sColHead[i], n2 + 2, this.tp.iRowHeight - 5);
            }
            if (this.tp.iColCount > 1) {
                this.gImage.setColor(Color.darkGray);
                this.gImage.drawLine(n2 + n3 - 1, 0, n2 + n3 - 1, this.tp.iRowHeight - 1);
                this.gImage.setColor(Color.white);
                this.gImage.drawLine(n2 + n3, 0, n2 + n3, this.tp.iRowHeight - 1);
            }
            n2 += n3;
        }
        this.gImage.setColor(Color.lightGray);
        this.gImage.fillRect(0, 0, 1, this.tp.iRowHeight);
        this.gImage.fillRect(n2 + 1, 0, n - n2, this.tp.iRowHeight);
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(0, 0, n, 0);
    }

    char[] getChars(int n, int n2) {
        int n3;
        if (this.tp == null) {
            return null;
        }
        if (n2 >= this.tp.vData.size()) {
            return null;
        }
        char[] cArray = (char[])this.tp.vData.elementAt(n2);
        if (cArray.length == 0) {
            return null;
        }
        if (this.tp.iColCount == 1) {
            return cArray;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = cArray.length;
        while (n > n5) {
            if (cArray[n4] == '\t') {
                ++n5;
            }
            if (++n4 < n6) continue;
            return null;
        }
        if (n4 < 0 || n4 >= cArray.length) {
            System.out.println("start=" + n4 + ", chars.length=" + cArray.length);
            return null;
        }
        if (cArray[n4] == '\t') {
            return null;
        }
        for (n3 = n4; cArray[n3] != '\t' && n3 < n6 - 1; ++n3) {
        }
        if (cArray[n3] == '\t') {
            --n3;
        }
        char[] cArray2 = new char[n3 - n4 + 1];
        int n7 = 0;
        int n8 = n4;
        while (n7 < cArray2.length) {
            cArray2[n7] = cArray[n8];
            ++n7;
            ++n8;
        }
        return cArray2;
    }

    void calcAutoWidth(int n) {
        char[] cArray;
        int n2;
        if (this.tp.sColHead == null || n >= this.tp.iColWidth.length || this.gImage == null) {
            return;
        }
        if (this.fMetrics == null) {
            this.fMetrics = this.gImage.getFontMetrics();
        }
        int n3 = 15;
        if (this.tp.iColCount == 1) {
            n2 = 100;
        } else {
            n2 = 20;
            if (n == 0 && this.tp.sColHead[0].equals(" ")) {
                n3 += 5;
            } else {
                char[] cArray2 = this.tp.sColHead[n].toCharArray();
                n3 = Math.max(n3, this.fMetrics.charsWidth(cArray2, 0, cArray2.length));
            }
        }
        int n4 = Math.min(this.tp.iRowCount, n2);
        for (int i = 0; i < n4; ++i) {
            char[] cArray3 = this.getChars(n, i);
            if (cArray3 == null) continue;
            n3 = Math.max(n3, this.fMetrics.charsWidth(cArray3, 0, cArray3.length));
        }
        char[] cArray4 = cArray = this.tp.iRowCount > 0 ? this.getChars(n, this.tp.iRowCount - 1) : null;
        if (cArray != null) {
            n3 = Math.max(n3, this.fMetrics.charsWidth(cArray, 0, cArray.length));
        }
        this.tp.iColWidth[n] = n3 + 15;
    }
}

