/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.measure.Calibration;
import ij.plugin.FileInfoVirtualStack;
import ij.plugin.FolderOpener;
import ij.process.ImageProcessor;
import java.io.File;
import java.util.Properties;

public class ImportDialog {
    private String fileName;
    private String directory;
    static final String TYPE = "raw.type";
    static final String WIDTH = "raw.width";
    static final String HEIGHT = "raw.height";
    static final String OFFSET = "raw.offset";
    static final String N = "raw.n";
    static final String GAP = "raw.gap";
    static final String OPTIONS = "raw.options";
    static final int WHITE_IS_ZERO = 1;
    static final int INTEL_BYTE_ORDER = 2;
    static final int OPEN_ALL = 4;
    private static int choiceSelection = Prefs.getInt("raw.type", 0);
    private static int width = Prefs.getInt("raw.width", 512);
    private static int height = Prefs.getInt("raw.height", 512);
    private static long offset = Prefs.getInt("raw.offset", 0);
    private static int nImages = Prefs.getInt("raw.n", 1);
    private static int gapBetweenImages = Prefs.getInt("raw.gap", 0);
    private static int options;
    private static boolean whiteIsZero;
    private static boolean intelByteOrder;
    private static boolean virtual;
    private boolean openAll;
    private static FileInfo lastFileInfo;
    private static String[] types;

    public ImportDialog(String string, String string2) {
        this.fileName = string;
        this.directory = string2;
        IJ.showStatus("Importing: " + string);
    }

    public ImportDialog() {
    }

    boolean showDialog() {
        if (choiceSelection >= types.length) {
            choiceSelection = 0;
        }
        GenericDialog genericDialog = new GenericDialog("Import...", IJ.getInstance());
        genericDialog.addChoice("Image type:", types, types[choiceSelection]);
        genericDialog.addNumericField("Width:", width, 0, 6, "pixels");
        genericDialog.addNumericField("Height:", height, 0, 6, "pixels");
        genericDialog.addNumericField("Offset to first image:", offset, 0, 6, "bytes");
        genericDialog.addNumericField("Number of images:", nImages, 0, 6, null);
        genericDialog.addNumericField("Gap between images:", gapBetweenImages, 0, 6, "bytes");
        genericDialog.addCheckbox("White is zero", whiteIsZero);
        genericDialog.addCheckbox("Little-endian byte order", intelByteOrder);
        genericDialog.addCheckbox("Open all files in folder", this.openAll);
        genericDialog.addCheckbox("Use virtual stack", virtual);
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/file.html#raw");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        choiceSelection = genericDialog.getNextChoiceIndex();
        width = (int)genericDialog.getNextNumber();
        height = (int)genericDialog.getNextNumber();
        offset = (long)genericDialog.getNextNumber();
        nImages = (int)genericDialog.getNextNumber();
        gapBetweenImages = (int)genericDialog.getNextNumber();
        whiteIsZero = genericDialog.getNextBoolean();
        intelByteOrder = genericDialog.getNextBoolean();
        this.openAll = genericDialog.getNextBoolean();
        virtual = genericDialog.getNextBoolean();
        IJ.register(ImportDialog.class);
        return true;
    }

    void openAll(String[] stringArray, FileInfo fileInfo) {
        FolderOpener folderOpener = new FolderOpener();
        stringArray = folderOpener.trimFileList(stringArray);
        if ((stringArray = folderOpener.sortFileList(stringArray)) == null) {
            return;
        }
        ImageStack imageStack = null;
        ImagePlus imagePlus = null;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith(".")) continue;
            fileInfo.fileName = stringArray[i];
            imagePlus = new FileOpener(fileInfo).open(false);
            if (imagePlus == null) {
                IJ.log(stringArray[i] + ": unable to open");
                continue;
            }
            if (imageStack == null) {
                imageStack = imagePlus.createEmptyStack();
            }
            try {
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                if (imageProcessor.getMin() < d) {
                    d = imageProcessor.getMin();
                }
                if (imageProcessor.getMax() > d2) {
                    d2 = imageProcessor.getMax();
                }
                imageStack.addSlice(stringArray[i], imageProcessor);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                IJ.outOfMemory("OpenAll");
                imageStack.trim();
                break;
            }
            IJ.showStatus(imageStack.getSize() + 1 + ": " + stringArray[i]);
        }
        if (imageStack != null) {
            imagePlus = new ImagePlus("Imported Stack", imageStack);
            if (imagePlus.getBitDepth() == 16 || imagePlus.getBitDepth() == 32) {
                imagePlus.getProcessor().setMinAndMax(d, d2);
            }
            Calibration calibration = imagePlus.getCalibration();
            if (fileInfo.fileType == 1) {
                calibration.setSigned16BitCalibration();
            }
            imagePlus.show();
        }
    }

    public void openImage() {
        FileInfo fileInfo = this.getFileInfo();
        if (fileInfo == null) {
            return;
        }
        if (this.openAll) {
            if (virtual) {
                virtual = false;
                IJ.error("Import Raw", "\"Open All\" does not currently support virtual stacks");
                return;
            }
            String[] stringArray = new File(this.directory).list();
            if (stringArray == null) {
                return;
            }
            this.openAll(stringArray, fileInfo);
        } else if (virtual) {
            new FileInfoVirtualStack(fileInfo);
        } else {
            FileOpener fileOpener = new FileOpener(fileInfo);
            ImagePlus imagePlus = fileOpener.open(false);
            if (imagePlus != null) {
                imagePlus.show();
                int n = imagePlus.getStackSize();
                if (n > 1) {
                    imagePlus.setSlice(n / 2);
                    ImageProcessor imageProcessor = imagePlus.getProcessor();
                    imageProcessor.resetMinAndMax();
                    imagePlus.setDisplayRange(imageProcessor.getMin(), imageProcessor.getMax());
                }
            }
        }
    }

    public FileInfo getFileInfo() {
        if (!this.showDialog()) {
            return null;
        }
        String string = types[choiceSelection];
        FileInfo fileInfo = new FileInfo();
        fileInfo.fileFormat = 1;
        fileInfo.fileName = this.fileName;
        fileInfo.directory = this.directory;
        fileInfo.width = width;
        fileInfo.height = height;
        if (offset > Integer.MAX_VALUE) {
            fileInfo.longOffset = offset;
        } else {
            fileInfo.offset = (int)offset;
        }
        fileInfo.nImages = nImages;
        fileInfo.gapBetweenImages = gapBetweenImages;
        fileInfo.intelByteOrder = intelByteOrder;
        fileInfo.whiteIsZero = whiteIsZero;
        fileInfo.fileType = string.equals("8-bit") ? 0 : (string.equals("16-bit Signed") ? 1 : (string.equals("16-bit Unsigned") ? 2 : (string.equals("32-bit Signed") ? 3 : (string.equals("32-bit Unsigned") ? 11 : (string.equals("32-bit Real") ? 4 : (string.equals("64-bit Real") ? 16 : (string.equals("24-bit RGB") ? 6 : (string.equals("24-bit RGB Planar") ? 7 : (string.equals("24-bit BGR") ? 10 : (string.equals("24-bit Integer") ? 14 : (string.equals("32-bit ARGB") ? 9 : (string.equals("32-bit ABGR") ? 18 : (string.equals("1-bit Bitmap") ? 8 : 0)))))))))))));
        if (IJ.debugMode) {
            IJ.log("ImportDialog: " + fileInfo);
        }
        lastFileInfo = (FileInfo)fileInfo.clone();
        return fileInfo;
    }

    public static void savePreferences(Properties properties) {
        properties.put(TYPE, Integer.toString(choiceSelection));
        properties.put(WIDTH, Integer.toString(width));
        properties.put(HEIGHT, Integer.toString(height));
        properties.put(OFFSET, Integer.toString(offset > Integer.MAX_VALUE ? 0 : (int)offset));
        properties.put(N, Integer.toString(nImages));
        properties.put(GAP, Integer.toString(gapBetweenImages));
        int n = 0;
        if (whiteIsZero) {
            n |= 1;
        }
        if (intelByteOrder) {
            n |= 2;
        }
        properties.put(OPTIONS, Integer.toString(n));
    }

    public static FileInfo getLastFileInfo() {
        return lastFileInfo;
    }

    static {
        types = new String[]{"8-bit", "16-bit Signed", "16-bit Unsigned", "32-bit Signed", "32-bit Unsigned", "32-bit Real", "64-bit Real", "24-bit RGB", "24-bit RGB Planar", "24-bit BGR", "24-bit Integer", "32-bit ARGB", "32-bit ABGR", "1-bit Bitmap"};
        options = Prefs.getInt(OPTIONS, 0);
        whiteIsZero = (options & 1) != 0;
        intelByteOrder = (options & 2) != 0;
    }
}

