/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.Plots;
import ij.plugin.PlotsCanvas;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;

public class GelAnalyzer
implements PlugIn {
    static final String OPTIONS = "gel.options";
    static final String VSCALE = "gel.vscale";
    static final String HSCALE = "gel.hscale";
    static final int OD = 1;
    static final int PERCENT = 2;
    static final int OUTLINE = 4;
    static final int INVERT = 8;
    static int saveID;
    static int nLanes;
    static int saveNLanes;
    static Rectangle firstRect;
    static final int MAX_LANES = 100;
    static int[] x;
    static PlotsCanvas plotsCanvas;
    static ImageProcessor ipLanes;
    static ImagePlus gel;
    static int plotHeight;
    static int options;
    static boolean uncalibratedOD;
    static boolean labelWithPercentages;
    static boolean outlineLanes;
    static boolean invertPeaks;
    static double verticalScaleFactor;
    static double horizontalScaleFactor;
    static Overlay overlay;
    boolean invertedLut;
    ImagePlus imp;
    Font f;
    double odMin = Double.MAX_VALUE;
    double odMax = -1.7976931348623157E308;
    static boolean isVertical;
    static boolean showLaneDialog;

    public void run(String string) {
        if (string.equals("options")) {
            this.showDialog();
            return;
        }
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (string.equals("reset")) {
            nLanes = 0;
            saveNLanes = 0;
            saveID = 0;
            if (plotsCanvas != null) {
                plotsCanvas.reset();
            }
            ipLanes = null;
            overlay = null;
            if (gel != null) {
                ImageCanvas imageCanvas = gel.getCanvas();
                if (imageCanvas != null) {
                    imageCanvas.setDisplayList(null);
                }
                gel.draw();
            }
            return;
        }
        if (string.equals("percent") && plotsCanvas != null) {
            plotsCanvas.displayPercentages();
            return;
        }
        if (string.equals("label") && plotsCanvas != null) {
            if (GelAnalyzer.plotsCanvas.counter == 0) {
                this.show("There are no peak area measurements.");
            } else {
                plotsCanvas.labelPeaks();
            }
            return;
        }
        if (this.imp.getID() != saveID) {
            nLanes = 0;
            ipLanes = null;
            saveID = 0;
        }
        if (string.equals("replot")) {
            if (saveNLanes == 0) {
                this.show("The data needed to re-plot the lanes is not available");
                return;
            }
            nLanes = saveNLanes;
            this.plotLanes(gel, true);
            return;
        }
        if (string.equals("draw")) {
            this.outlineLanes();
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi == null || roi.getType() != 0) {
            this.show("Rectangular selection required.");
            return;
        }
        Rectangle rectangle = roi.getBounds();
        if (nLanes == 0) {
            this.invertedLut = this.imp.isInvertedLut();
            IJ.register(GelAnalyzer.class);
        }
        if (string.equals("first")) {
            this.selectFirstLane(rectangle);
            return;
        }
        if (nLanes == 0) {
            this.show("You must first use the \"Outline First Lane\" command.");
            return;
        }
        if (string.equals("next")) {
            this.selectNextLane(rectangle);
            return;
        }
        if (string.equals("plot")) {
            if (isVertical && rectangle.x != x[nLanes] || !isVertical && rectangle.y != x[nLanes]) {
                this.selectNextLane(rectangle);
            }
            this.plotLanes(gel, false);
            return;
        }
    }

    void showDialog() {
        GenericDialog genericDialog = new GenericDialog("Gel Analyzer");
        genericDialog.addNumericField("Vertical scale factor:", verticalScaleFactor, 1);
        genericDialog.addNumericField("Horizontal scale factor:", horizontalScaleFactor, 1);
        genericDialog.addCheckbox("Uncalibrated OD", uncalibratedOD);
        genericDialog.addCheckbox("Label with percentages", labelWithPercentages);
        genericDialog.addCheckbox("Invert peaks", invertPeaks);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        verticalScaleFactor = genericDialog.getNextNumber();
        horizontalScaleFactor = genericDialog.getNextNumber();
        uncalibratedOD = genericDialog.getNextBoolean();
        labelWithPercentages = genericDialog.getNextBoolean();
        invertPeaks = genericDialog.getNextBoolean();
        options = 0;
        if (uncalibratedOD) {
            options |= 1;
        }
        if (labelWithPercentages) {
            options |= 2;
        }
        if (invertPeaks) {
            options |= 8;
        }
        Prefs.set(OPTIONS, options);
        Prefs.set(VSCALE, verticalScaleFactor);
        Prefs.set(HSCALE, horizontalScaleFactor);
    }

    void selectFirstLane(Rectangle rectangle) {
        if (rectangle.width / rectangle.height >= 2 || IJ.altKeyDown()) {
            if (showLaneDialog) {
                String string = "Are the lanes really horizontal?\n \nImageJ assumes the lanes are\nhorizontal if the selection is more\nthan twice as wide as it is tall. Note\nthat the selection can only be moved\nvertically when the lanes are horizontal.";
                GenericDialog genericDialog = new GenericDialog("Gel Analyzer");
                genericDialog.addMessage(string);
                genericDialog.setOKLabel("Yes");
                genericDialog.showDialog();
                if (genericDialog.wasCanceled()) {
                    return;
                }
                showLaneDialog = false;
            }
            isVertical = false;
        } else {
            isVertical = true;
        }
        IJ.showStatus("Lane 1 selected (" + (isVertical ? "vertical" : "horizontal") + " lanes)");
        firstRect = rectangle;
        nLanes = 1;
        saveNLanes = 0;
        GelAnalyzer.x[1] = isVertical ? rectangle.x : rectangle.y;
        gel = this.imp;
        saveID = this.imp.getID();
        overlay = null;
        this.updateRoiList(rectangle);
    }

    void selectNextLane(Rectangle rectangle) {
        if (rectangle.width != GelAnalyzer.firstRect.width || rectangle.height != GelAnalyzer.firstRect.height) {
            this.show("Selections must all be the same size.");
            return;
        }
        if (nLanes < 100) {
            ++nLanes;
        }
        IJ.showStatus("Lane " + nLanes + " selected");
        GelAnalyzer.x[GelAnalyzer.nLanes] = isVertical ? rectangle.x : rectangle.y;
        if (isVertical && rectangle.y != GelAnalyzer.firstRect.y) {
            rectangle.y = GelAnalyzer.firstRect.y;
            gel.setRoi(rectangle);
        } else if (!isVertical && rectangle.x != GelAnalyzer.firstRect.x) {
            rectangle.x = GelAnalyzer.firstRect.x;
            gel.setRoi(rectangle);
        }
        this.updateRoiList(rectangle);
    }

    void updateRoiList(Rectangle rectangle) {
        if (gel == null) {
            return;
        }
        if (overlay == null) {
            overlay = new Overlay();
            overlay.drawLabels(true);
        }
        overlay.add(new Roi(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null));
        gel.setOverlay(overlay);
    }

    void plotLanes(ImagePlus imagePlus, boolean bl) {
        int n;
        Object object;
        int n2 = 16;
        int n3 = 2;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double[][] dArrayArray = new double[101][];
        IJ.showStatus("Plotting " + nLanes + " lanes");
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (isVertical) {
            imageProcessor = imageProcessor.rotateLeft();
        }
        ImagePlus imagePlus2 = new ImagePlus("", imageProcessor);
        imagePlus2.setCalibration(imagePlus.getCalibration());
        if (uncalibratedOD && (imagePlus2.getType() == 1 || imagePlus2.getType() == 2)) {
            new ImageConverter(imagePlus2).convertToGray8();
        }
        if (invertPeaks) {
            ImageProcessor imageProcessor2 = imagePlus2.getProcessor().duplicate();
            imageProcessor2.invert();
            imagePlus2.setProcessor(null, imageProcessor2);
        }
        for (int i = 1; i <= nLanes; ++i) {
            if (isVertical) {
                imagePlus2.setRoi(GelAnalyzer.firstRect.y, imageProcessor.getHeight() - x[i] - GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height, GelAnalyzer.firstRect.width);
            } else {
                imagePlus2.setRoi(GelAnalyzer.firstRect.x, x[i], GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
            }
            object = new ProfilePlot(imagePlus2);
            dArrayArray[i] = ((ProfilePlot)object).getProfile();
            if (((ProfilePlot)object).getMin() < d) {
                d = ((ProfilePlot)object).getMin();
            }
            if (((ProfilePlot)object).getMax() > d2) {
                d2 = ((ProfilePlot)object).getMax();
            }
            if (!uncalibratedOD) continue;
            dArrayArray[i] = this.od(dArrayArray[i]);
        }
        if (uncalibratedOD) {
            d = this.odMin;
            d2 = this.odMax;
        }
        if ((n = isVertical ? GelAnalyzer.firstRect.height : GelAnalyzer.firstRect.width) < 650) {
            n = 650;
        }
        if (isVertical) {
            if (n > 4 * GelAnalyzer.firstRect.height) {
                n = 4 * GelAnalyzer.firstRect.height;
            }
        } else if (n > 4 * GelAnalyzer.firstRect.width) {
            n = 4 * GelAnalyzer.firstRect.width;
        }
        Dimension dimension = IJ.getScreenSize();
        if (n > dimension.width - dimension.width / 6) {
            n = dimension.width - dimension.width / 6;
        }
        if ((plotHeight = (n = (int)((double)n * horizontalScaleFactor)) / 2) < 250) {
            plotHeight = 250;
        }
        plotHeight = (int)((double)plotHeight * verticalScaleFactor);
        object = new ByteProcessor(n, n2 + nLanes * plotHeight + n3);
        ((ImageProcessor)object).setColor(Color.white);
        ((ImageProcessor)object).fill();
        ((ImageProcessor)object).setColor(Color.black);
        int n4 = ((ImageProcessor)object).getHeight();
        ((ImageProcessor)object).moveTo(0, 0);
        ((ImageProcessor)object).lineTo(n - 1, 0);
        ((ImageProcessor)object).lineTo(n - 1, n4 - 1);
        ((ImageProcessor)object).lineTo(0, n4 - 1);
        ((ImageProcessor)object).lineTo(0, 0);
        ((ImageProcessor)object).moveTo(0, n4 - 2);
        ((ImageProcessor)object).lineTo(n - 1, n4 - 2);
        String string = imagePlus.getTitle() + "; ";
        Calibration calibration = imagePlus.getCalibration();
        string = calibration.calibrated() ? string + calibration.getValueUnit() : (uncalibratedOD ? string + "Uncalibrated OD" : string + "Uncalibrated");
        ((ImageProcessor)object).moveTo(5, n2);
        ((ImageProcessor)object).drawString(string);
        double d3 = (double)n / (double)dArrayArray[1].length;
        double d4 = d2 - d == 0.0 ? 1.0 : (double)plotHeight / (d2 - d);
        for (int i = 1; i <= nLanes; ++i) {
            double[] dArray = dArrayArray[i];
            int n5 = (i - 1) * plotHeight + n2;
            int n6 = n5 + plotHeight;
            ((ImageProcessor)object).moveTo(0, n6);
            ((ImageProcessor)object).lineTo((int)((double)dArray.length * d3), n6);
            ((ImageProcessor)object).moveTo(0, n6 - (int)((dArray[0] - d) * d4));
            for (int j = 1; j < dArray.length; ++j) {
                ((ImageProcessor)object).lineTo((int)((double)j * d3 + 0.5), n6 - (int)((dArray[j] - d) * d4 + 0.5));
            }
        }
        Line.setWidth(1);
        Plots plots = new Plots();
        plots.setProcessor("Plots of " + imagePlus.getShortTitle(), (ImageProcessor)object);
        plots.changes = true;
        ((ImageProcessor)object).setThreshold(0.0, 0.0, 2);
        if (calibration.calibrated()) {
            double d5 = isVertical ? (double)GelAnalyzer.firstRect.width : (double)GelAnalyzer.firstRect.height;
            double d6 = Math.sqrt(d3 * d4 / d5);
            Calibration calibration2 = plots.getCalibration();
            calibration2.setUnit("unit");
            calibration2.pixelWidth = 1.0 / d6;
            calibration2.pixelHeight = 1.0 / d6;
        }
        ((ImagePlus)plots).show();
        saveNLanes = nLanes;
        nLanes = 0;
        saveID = 0;
        ipLanes = null;
        Toolbar toolbar = Toolbar.getInstance();
        toolbar.setColor(Color.black);
        toolbar.setTool(4);
        ImageWindow imageWindow = WindowManager.getCurrentWindow();
        ImageCanvas imageCanvas = imageWindow.getCanvas();
        plotsCanvas = imageCanvas instanceof PlotsCanvas ? (PlotsCanvas)imageCanvas : null;
    }

    double[] od(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            double d = 0.434294481 * Math.log(255.0 / (255.0 - dArray[i]));
            if (d < this.odMin) {
                this.odMin = d;
            }
            if (d > this.odMax) {
                this.odMax = d;
            }
            dArray[i] = d;
        }
        return dArray;
    }

    void outlineLanes() {
        if (gel == null || overlay == null) {
            this.show("Data needed to outline lanes is no longer available.");
            return;
        }
        int n = (int)(1.0 / gel.getCanvas().getMagnification());
        if (n < 1) {
            n = 1;
        }
        Font font = new Font("Helvetica", 0, 12 * n);
        ImageProcessor imageProcessor = gel.getProcessor();
        ImageProcessor imageProcessor2 = imageProcessor.duplicate();
        if (!(imageProcessor2 instanceof ByteProcessor)) {
            imageProcessor2 = imageProcessor2.convertToByte(true);
        }
        imageProcessor2.setFont(font);
        imageProcessor2.setLineWidth(n);
        this.setCustomLut(imageProcessor2);
        ImagePlus imagePlus = new ImagePlus("Lanes of " + gel.getShortTitle(), imageProcessor2);
        imagePlus.changes = true;
        imagePlus.setRoi(gel.getRoi());
        gel.killRoi();
        for (int i = 0; i < overlay.size(); ++i) {
            int n2;
            Roi roi = overlay.get(i);
            Rectangle rectangle = roi.getBounds();
            imageProcessor2.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            String string = "" + (i + 1);
            if (isVertical) {
                n2 = rectangle.y;
                if (n2 < n * 12) {
                    n2 += n * 14;
                }
                imageProcessor2.drawString(string, rectangle.x + rectangle.width / 2 - imageProcessor2.getStringWidth(string) / 2, n2);
                continue;
            }
            n2 = rectangle.x - imageProcessor2.getStringWidth(string) - 2;
            if (n2 < n * 10) {
                n2 = rectangle.x + 2;
            }
            imageProcessor2.drawString(string, n2, rectangle.y + rectangle.height / 2 + 6);
        }
        imagePlus.killRoi();
        imagePlus.show();
    }

    void setCustomLut(ImageProcessor imageProcessor) {
        IndexColorModel indexColorModel = (IndexColorModel)imageProcessor.getColorModel();
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        byArray[1] = -1;
        byArray2[1] = 0;
        byArray3[1] = 0;
        imageProcessor.setColorModel(new IndexColorModel(8, 256, byArray, byArray2, byArray3));
        byte[] byArray4 = (byte[])imageProcessor.getPixels();
        for (int i = 0; i < byArray4.length; ++i) {
            if ((byArray4[i] & 0xFF) != 1) continue;
            byArray4[i] = 0;
        }
        imageProcessor.setColor(1);
    }

    void show(String string) {
        IJ.showMessage("Gel Analyzer", string);
    }

    static {
        x = new int[101];
        options = (int)Prefs.get(OPTIONS, 10.0);
        uncalibratedOD = (options & 1) != 0;
        labelWithPercentages = (options & 2) != 0;
        invertPeaks = (options & 8) != 0;
        verticalScaleFactor = Prefs.get(VSCALE, 1.0);
        horizontalScaleFactor = Prefs.get(HSCALE, 1.0);
        showLaneDialog = true;
    }
}

