/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CommandListener;
import ij.Executer;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.ScrollbarWithLabel;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.GeneralPath;
import java.awt.image.ColorModel;

public class Orthogonal_Views
implements PlugIn,
MouseListener,
MouseMotionListener,
KeyListener,
ActionListener,
ImageListener,
WindowListener,
AdjustmentListener,
MouseWheelListener,
FocusListener,
CommandListener {
    private ImageWindow win;
    private ImagePlus imp;
    private ImageCanvas canvas;
    private static final int H_ROI = 0;
    private static final int H_ZOOM = 1;
    private static boolean sticky = true;
    private static int xzID;
    private static int yzID;
    private static Orthogonal_Views instance;
    private ImagePlus xz_image;
    private ImagePlus yz_image;
    private ImageProcessor fp1;
    private ImageProcessor fp2;
    private double ax;
    private double ay;
    private double az;
    private boolean rotateYZ = Prefs.rotateYZ;
    private boolean flipXZ = Prefs.flipXZ;
    private int xyX;
    private int xyY;
    private Calibration cal = null;
    private Calibration cal_xz = new Calibration();
    private Calibration cal_yz = new Calibration();
    private double magnification = 1.0;
    private Color color = Roi.getColor();
    private Updater updater = new Updater();
    private double min;
    private double max;
    private Dimension screen = IJ.getScreenSize();
    private boolean syncZoom = true;
    private Point crossLoc;
    private boolean firstTime = true;

    public void run(String string) {
        this.imp = IJ.getImage();
        if (this.imp.getStackSize() == 1) {
            IJ.error("Othogonal Views", "This command requires a stack.");
            return;
        }
        if (this.imp.isComposite() || this.imp.isHyperStack()) {
            IJ.error("Othogonal Views", "This command does not work with hyperstacks. Try\nconverting to an RGB stack using Image>Type>RGB Color.");
            return;
        }
        if (instance != null && this.imp == Orthogonal_Views.instance.imp) {
            return;
        }
        this.yz_image = WindowManager.getImage(yzID);
        if (this.yz_image == null || this.yz_image.getHeight() != this.imp.getHeight() || this.yz_image.getBitDepth() != this.imp.getBitDepth()) {
            this.yz_image = new ImagePlus();
        }
        this.xz_image = WindowManager.getImage(xzID);
        if (this.xz_image == null || this.xz_image.getWidth() != this.imp.getWidth() || this.xz_image.getBitDepth() != this.imp.getBitDepth()) {
            this.xz_image = new ImagePlus();
        }
        instance = this;
        ImageProcessor imageProcessor = this.imp.getProcessor();
        this.min = imageProcessor.getMin();
        this.max = imageProcessor.getMax();
        this.cal = this.imp.getCalibration();
        double d = this.cal.pixelWidth;
        double d2 = this.cal.pixelHeight;
        double d3 = this.cal.pixelDepth;
        this.ax = 1.0;
        this.ay = d2 / d;
        this.az = d3 / d;
        this.win = this.imp.getWindow();
        this.canvas = this.win.getCanvas();
        this.addListeners(this.canvas);
        this.magnification = this.canvas.getMagnification();
        this.imp.killRoi();
        Rectangle rectangle = this.canvas.getSrcRect();
        this.crossLoc = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        ImageStack imageStack = this.imp.getStack();
        this.calibrate();
        if (this.createProcessors(imageStack)) {
            if (imageProcessor.isColorLut() || imageProcessor.isInvertedLut()) {
                ColorModel colorModel = imageProcessor.getColorModel();
                this.fp1.setColorModel(colorModel);
                this.fp2.setColorModel(colorModel);
            }
            this.update();
        } else {
            this.dispose();
        }
    }

    private void addListeners(ImageCanvas imageCanvas) {
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        this.canvas.addKeyListener(this);
        this.win.addWindowListener(this);
        this.win.addMouseWheelListener(this);
        this.win.addFocusListener(this);
        Component[] componentArray = this.win.getComponents();
        ((ScrollbarWithLabel)componentArray[1]).addAdjustmentListener(this);
        ImagePlus.addImageListener(this);
        Executer.addCommandListener(this);
    }

    private void calibrate() {
        String string = this.cal.getUnit();
        double d = this.cal.pixelDepth;
        double d2 = this.cal.pixelHeight;
        double d3 = this.cal.pixelWidth;
        this.cal_yz.setUnit(string);
        if (this.rotateYZ) {
            this.cal_yz.pixelHeight = d / this.az;
            this.cal_yz.pixelWidth = d2;
        } else {
            this.cal_yz.pixelWidth = d / this.az;
            this.cal_yz.pixelHeight = d2;
        }
        this.yz_image.setCalibration(this.cal_yz);
        this.cal_xz.setUnit(string);
        this.cal_xz.pixelWidth = d3;
        this.cal_xz.pixelHeight = d / this.az;
        this.xz_image.setCalibration(this.cal_xz);
    }

    private void updateMagnification(int n, int n2) {
        double d = this.win.getCanvas().getMagnification();
        int n3 = this.imp.getCurrentSlice() - 1;
        ImageWindow imageWindow = this.xz_image.getWindow();
        if (imageWindow == null) {
            return;
        }
        ImageCanvas imageCanvas = imageWindow.getCanvas();
        double d2 = imageCanvas.getMagnification();
        double d3 = this.az / this.ax;
        int n4 = (int)(d3 * (double)n3);
        if (this.flipXZ) {
            n4 = (int)(d3 * (double)(this.imp.getStackSize() - n3));
        }
        while (d2 < d) {
            imageCanvas.zoomIn(imageCanvas.screenX(n), imageCanvas.screenY(n4));
            d2 = imageCanvas.getMagnification();
        }
        while (d2 > d) {
            imageCanvas.zoomOut(imageCanvas.screenX(n), imageCanvas.screenY(n4));
            d2 = imageCanvas.getMagnification();
        }
        ImageWindow imageWindow2 = this.yz_image.getWindow();
        if (imageWindow2 == null) {
            return;
        }
        ImageCanvas imageCanvas2 = imageWindow2.getCanvas();
        double d4 = imageCanvas2.getMagnification();
        n4 = (int)(d3 * (double)n3);
        while (d4 < d) {
            imageCanvas2.zoomIn(imageCanvas2.screenX(n4), imageCanvas2.screenY(n2));
            d4 = imageCanvas2.getMagnification();
        }
        while (d4 > d) {
            imageCanvas2.zoomOut(imageCanvas2.screenX(n4), imageCanvas2.screenY(n2));
            d4 = imageCanvas2.getMagnification();
        }
    }

    void updateViews(Point point, ImageStack imageStack) {
        Object object;
        Object object2;
        if (this.fp1 == null) {
            return;
        }
        this.updateXZView(point, imageStack);
        double d = this.az / this.ax;
        int n = this.fp1.getWidth();
        int n2 = (int)Math.round((double)this.fp1.getHeight() * this.az);
        if (n != this.fp1.getWidth() || n2 != this.fp1.getHeight()) {
            this.fp1.setInterpolate(true);
            object2 = this.fp1.resize(n, n2);
            ((ImageProcessor)object2).setMinAndMax(this.min, this.max);
            this.xz_image.setProcessor("XZ " + point.y, (ImageProcessor)object2);
        } else {
            this.fp1.setMinAndMax(this.min, this.max);
            this.xz_image.setProcessor("XZ " + point.y, this.fp1);
        }
        if (this.rotateYZ) {
            this.updateYZView(point, imageStack);
        } else {
            this.updateZYView(point, imageStack);
        }
        n = (int)Math.round((double)this.fp2.getWidth() * this.az);
        n2 = this.fp2.getHeight();
        object2 = "YZ ";
        if (this.rotateYZ) {
            n = this.fp2.getWidth();
            n2 = (int)Math.round((double)this.fp2.getHeight() * this.az);
            object2 = "ZY ";
        }
        if (n != this.fp2.getWidth() || n2 != this.fp2.getHeight()) {
            this.fp2.setInterpolate(true);
            object = this.fp2.resize(n, n2);
            ((ImageProcessor)object).setMinAndMax(this.min, this.max);
            this.yz_image.setProcessor((String)object2 + point.x, (ImageProcessor)object);
        } else {
            this.fp2.setMinAndMax(this.min, this.max);
            this.yz_image.setProcessor((String)object2 + point.x, this.fp2);
        }
        this.calibrate();
        if (this.yz_image.getWindow() == null) {
            this.yz_image.show();
            object = this.yz_image.getCanvas();
            ((Component)object).addKeyListener(this);
            ((Component)object).addMouseListener(this);
            ((Component)object).addMouseMotionListener(this);
            ((ImageCanvas)object).setCustomRoi(true);
            this.yz_image.getWindow().addMouseWheelListener(this);
            yzID = this.yz_image.getID();
        }
        if (this.xz_image.getWindow() == null) {
            this.xz_image.show();
            object = this.xz_image.getCanvas();
            ((Component)object).addKeyListener(this);
            ((Component)object).addMouseListener(this);
            ((Component)object).addMouseMotionListener(this);
            ((ImageCanvas)object).setCustomRoi(true);
            this.xz_image.getWindow().addMouseWheelListener(this);
            xzID = this.xz_image.getID();
        }
    }

    void arrangeWindows(boolean bl) {
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow == null) {
            return;
        }
        Point point = imageWindow.getLocation();
        if (this.xyX != point.x || this.xyY != point.y) {
            this.xyX = point.x;
            this.xyY = point.y;
            ImageWindow imageWindow2 = null;
            long l = System.currentTimeMillis();
            while (imageWindow2 == null && System.currentTimeMillis() - l <= 2500L) {
                imageWindow2 = this.yz_image.getWindow();
                if (imageWindow2 != null) continue;
                IJ.wait(50);
            }
            if (imageWindow2 != null) {
                imageWindow2.setLocation(this.xyX + imageWindow.getWidth(), this.xyY);
            }
            ImageWindow imageWindow3 = null;
            l = System.currentTimeMillis();
            while (imageWindow3 == null && System.currentTimeMillis() - l <= 2500L) {
                imageWindow3 = this.xz_image.getWindow();
                if (imageWindow3 != null) continue;
                IJ.wait(50);
            }
            if (imageWindow3 != null) {
                imageWindow3.setLocation(this.xyX, this.xyY + imageWindow.getHeight());
            }
            if (this.firstTime) {
                this.imp.getWindow().toFront();
                this.imp.setSlice(this.imp.getStackSize() / 2);
                this.firstTime = false;
            }
        }
    }

    boolean createProcessors(ImageStack imageStack) {
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        int n = imageStack.getWidth();
        int n2 = imageStack.getHeight();
        int n3 = imageStack.getSize();
        double d = 1.0;
        double d2 = 1.0;
        int n4 = (int)((double)n3 * d);
        int n5 = (int)((double)n3 * d2);
        if (imageProcessor instanceof FloatProcessor) {
            this.fp1 = new FloatProcessor(n, n4);
            this.fp2 = this.rotateYZ ? new FloatProcessor(n2, n5) : new FloatProcessor(n5, n2);
            return true;
        }
        if (imageProcessor instanceof ByteProcessor) {
            this.fp1 = new ByteProcessor(n, n4);
            this.fp2 = this.rotateYZ ? new ByteProcessor(n2, n5) : new ByteProcessor(n5, n2);
            return true;
        }
        if (imageProcessor instanceof ShortProcessor) {
            this.fp1 = new ShortProcessor(n, n4);
            this.fp2 = this.rotateYZ ? new ShortProcessor(n2, n5) : new ShortProcessor(n5, n2);
            return true;
        }
        if (imageProcessor instanceof ColorProcessor) {
            this.fp1 = new ColorProcessor(n, n4);
            this.fp2 = this.rotateYZ ? new ColorProcessor(n2, n5) : new ColorProcessor(n5, n2);
            return true;
        }
        return false;
    }

    void updateXZView(Point point, ImageStack imageStack) {
        int n = imageStack.getWidth();
        int n2 = imageStack.getSize();
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        int n3 = point.y;
        if (imageProcessor instanceof ShortProcessor) {
            short[] sArray = new short[n * n2];
            for (int i = 0; i < n2; ++i) {
                Object object = imageStack.getPixels(i + 1);
                if (this.flipXZ) {
                    System.arraycopy(object, n * n3, sArray, n * (n2 - i - 1), n);
                    continue;
                }
                System.arraycopy(object, n * n3, sArray, n * i, n);
            }
            this.fp1.setPixels(sArray);
            return;
        }
        if (imageProcessor instanceof ByteProcessor) {
            byte[] byArray = new byte[n * n2];
            for (int i = 0; i < n2; ++i) {
                Object object = imageStack.getPixels(i + 1);
                if (this.flipXZ) {
                    System.arraycopy(object, n * n3, byArray, n * (n2 - i - 1), n);
                    continue;
                }
                System.arraycopy(object, n * n3, byArray, n * i, n);
            }
            this.fp1.setPixels(byArray);
            return;
        }
        if (imageProcessor instanceof FloatProcessor) {
            float[] fArray = new float[n * n2];
            for (int i = 0; i < n2; ++i) {
                Object object = imageStack.getPixels(i + 1);
                if (this.flipXZ) {
                    System.arraycopy(object, n * n3, fArray, n * (n2 - i - 1), n);
                    continue;
                }
                System.arraycopy(object, n * n3, fArray, n * i, n);
            }
            this.fp1.setPixels(fArray);
            return;
        }
        if (imageProcessor instanceof ColorProcessor) {
            int[] nArray = new int[n * n2];
            for (int i = 0; i < n2; ++i) {
                Object object = imageStack.getPixels(i + 1);
                if (this.flipXZ) {
                    System.arraycopy(object, n * n3, nArray, n * (n2 - i - 1), n);
                    continue;
                }
                System.arraycopy(object, n * n3, nArray, n * i, n);
            }
            this.fp1.setPixels(nArray);
            return;
        }
    }

    void updateYZView(Point point, ImageStack imageStack) {
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        int n3 = imageStack.getWidth();
        int n4 = imageStack.getHeight();
        int n5 = imageStack.getSize();
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        int n6 = point.x;
        if (imageProcessor instanceof FloatProcessor) {
            objectArray2 = new float[n5 * n4];
            for (n2 = 0; n2 < n5; ++n2) {
                objectArray = (float[])imageStack.getPixels(n2 + 1);
                for (n = 0; n < n4; ++n) {
                    objectArray2[(n5 - n2 - 1) * n4 + n] = objectArray[n6 + n * n3];
                }
            }
            this.fp2.setPixels(objectArray2);
        }
        if (imageProcessor instanceof ByteProcessor) {
            objectArray2 = new byte[n5 * n4];
            for (n2 = 0; n2 < n5; ++n2) {
                objectArray = (byte[])imageStack.getPixels(n2 + 1);
                for (n = 0; n < n4; ++n) {
                    objectArray2[(n5 - n2 - 1) * n4 + n] = objectArray[n6 + n * n3];
                }
            }
            this.fp2.setPixels(objectArray2);
        }
        if (imageProcessor instanceof ShortProcessor) {
            objectArray2 = new short[n5 * n4];
            for (n2 = 0; n2 < n5; ++n2) {
                objectArray = (short[])imageStack.getPixels(n2 + 1);
                for (n = 0; n < n4; ++n) {
                    objectArray2[(n5 - n2 - 1) * n4 + n] = objectArray[n6 + n * n3];
                }
            }
            this.fp2.setPixels(objectArray2);
        }
        if (imageProcessor instanceof ColorProcessor) {
            objectArray2 = new int[n5 * n4];
            for (n2 = 0; n2 < n5; ++n2) {
                objectArray = (int[])imageStack.getPixels(n2 + 1);
                for (n = 0; n < n4; ++n) {
                    objectArray2[(n5 - n2 - 1) * n4 + n] = objectArray[n6 + n * n3];
                }
            }
            this.fp2.setPixels(objectArray2);
        }
        if (!this.flipXZ) {
            this.fp2.flipVertical();
        }
    }

    void updateZYView(Point point, ImageStack imageStack) {
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        int n3 = imageStack.getWidth();
        int n4 = imageStack.getHeight();
        int n5 = imageStack.getSize();
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        int n6 = point.x;
        if (imageProcessor instanceof FloatProcessor) {
            objectArray2 = new float[n5 * n4];
            for (n2 = 0; n2 < n5; ++n2) {
                objectArray = (float[])imageStack.getPixels(n2 + 1);
                for (n = 0; n < n4; ++n) {
                    objectArray2[n2 + n * n5] = objectArray[n6 + n * n3];
                }
            }
            this.fp2.setPixels(objectArray2);
        }
        if (imageProcessor instanceof ByteProcessor) {
            objectArray2 = new byte[n5 * n4];
            for (n2 = 0; n2 < n5; ++n2) {
                objectArray = (byte[])imageStack.getPixels(n2 + 1);
                for (n = 0; n < n4; ++n) {
                    objectArray2[n2 + n * n5] = objectArray[n6 + n * n3];
                }
            }
            this.fp2.setPixels(objectArray2);
        }
        if (imageProcessor instanceof ShortProcessor) {
            objectArray2 = new short[n5 * n4];
            for (n2 = 0; n2 < n5; ++n2) {
                objectArray = (short[])imageStack.getPixels(n2 + 1);
                for (n = 0; n < n4; ++n) {
                    objectArray2[n2 + n * n5] = objectArray[n6 + n * n3];
                }
            }
            this.fp2.setPixels(objectArray2);
        }
        if (imageProcessor instanceof ColorProcessor) {
            objectArray2 = new int[n5 * n4];
            for (n2 = 0; n2 < n5; ++n2) {
                objectArray = (int[])imageStack.getPixels(n2 + 1);
                for (n = 0; n < n4; ++n) {
                    objectArray2[n2 + n * n5] = objectArray[n6 + n * n3];
                }
            }
            this.fp2.setPixels(objectArray2);
        }
    }

    void drawCross(ImagePlus imagePlus, Point point, GeneralPath generalPath) {
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        float f = point.x;
        float f2 = point.y;
        generalPath.moveTo(0.0f, f2);
        generalPath.lineTo(n, f2);
        generalPath.moveTo(f, 0.0f);
        generalPath.lineTo(f, n2);
    }

    void dispose() {
        Component component;
        this.updater.quit();
        this.updater = null;
        this.imp.setOverlay(null);
        this.canvas.removeMouseListener(this);
        this.canvas.removeMouseMotionListener(this);
        this.canvas.removeKeyListener(this);
        this.canvas.setCustomRoi(false);
        this.xz_image.setOverlay(null);
        ImageWindow imageWindow = this.xz_image.getWindow();
        if (imageWindow != null) {
            imageWindow.removeMouseWheelListener(this);
            component = imageWindow.getCanvas();
            if (component != null) {
                component.removeKeyListener(this);
                component.removeMouseListener(this);
                component.removeMouseMotionListener(this);
                ((ImageCanvas)component).setCustomRoi(false);
            }
        }
        this.yz_image.setOverlay(null);
        component = this.yz_image.getWindow();
        if (component != null) {
            component.removeMouseWheelListener(this);
            ImageCanvas imageCanvas = ((ImageWindow)component).getCanvas();
            if (imageCanvas != null) {
                imageCanvas.removeKeyListener(this);
                imageCanvas.removeMouseListener(this);
                imageCanvas.removeMouseMotionListener(this);
                imageCanvas.setCustomRoi(false);
            }
        }
        ImagePlus.removeImageListener(this);
        Executer.removeCommandListener(this);
        this.win.removeWindowListener(this);
        this.win.removeFocusListener(this);
        this.win.setResizable(true);
        instance = null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.canvas)) {
            this.crossLoc = this.canvas.getCursorLoc();
        } else if (mouseEvent.getSource().equals(this.xz_image.getCanvas())) {
            this.crossLoc.x = this.xz_image.getCanvas().getCursorLoc().x;
            int n = this.xz_image.getCanvas().getCursorLoc().y;
            int n2 = (int)Math.round((double)n / this.az);
            this.imp.setSlice(n2 + 1);
        } else if (mouseEvent.getSource().equals(this.yz_image.getCanvas())) {
            int n;
            if (this.rotateYZ) {
                this.crossLoc.y = this.yz_image.getCanvas().getCursorLoc().x;
                n = this.yz_image.getCanvas().getCursorLoc().y;
            } else {
                this.crossLoc.y = this.yz_image.getCanvas().getCursorLoc().y;
                n = this.yz_image.getCanvas().getCursorLoc().x;
            }
            int n3 = (int)Math.round((double)n / this.az);
            this.imp.setSlice(n3 + 1);
        }
        this.update();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void update() {
        if (this.updater != null) {
            this.updater.doUpdate();
        }
    }

    private void exec() {
        if (this.canvas == null) {
            return;
        }
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        ImageStack imageStack = this.imp.getStack();
        double d = this.az / this.ax;
        double d2 = this.az / this.ay;
        Point point = this.crossLoc;
        if (point.y >= n2) {
            point.y = n2 - 1;
        }
        if (point.x >= n) {
            point.x = n - 1;
        }
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        this.updateViews(point, imageStack);
        GeneralPath generalPath = new GeneralPath();
        this.drawCross(this.imp, point, generalPath);
        this.imp.setOverlay(generalPath, this.color, new BasicStroke(1.0f));
        this.canvas.setCustomRoi(true);
        this.updateCrosses(point.x, point.y, d, d2);
        if (this.syncZoom) {
            this.updateMagnification(point.x, point.y);
        }
        this.arrangeWindows(sticky);
    }

    private void updateCrosses(int n, int n2, double d, double d2) {
        int n3 = this.imp.getNSlices();
        int n4 = this.imp.getCurrentSlice() - 1;
        int n5 = (int)Math.round(d * (double)n4);
        if (this.flipXZ) {
            n5 = (int)Math.round(d * (double)(n3 - n4));
        }
        Point point = new Point(n, n5);
        GeneralPath generalPath = new GeneralPath();
        this.drawCross(this.xz_image, point, generalPath);
        this.xz_image.setOverlay(generalPath, this.color, new BasicStroke(1.0f));
        if (this.rotateYZ) {
            n5 = this.flipXZ ? (int)Math.round(d2 * (double)(n3 - n4)) : (int)Math.round(d2 * (double)n4);
            point = new Point(n2, n5);
        } else {
            n5 = (int)Math.round(d * (double)n4);
            point = new Point(n5, n2);
        }
        generalPath = new GeneralPath();
        this.drawCross(this.yz_image, point, generalPath);
        this.yz_image.setOverlay(generalPath, this.color, new BasicStroke(1.0f));
        IJ.showStatus(this.imp.getLocationAsString(this.crossLoc.x, this.crossLoc.y));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            IJ.beep();
            this.dispose();
        } else if (IJ.shiftKeyDown()) {
            int n2 = this.imp.getWidth();
            int n3 = this.imp.getHeight();
            switch (n) {
                case 37: {
                    --this.crossLoc.x;
                    if (this.crossLoc.x >= 0) break;
                    this.crossLoc.x = 0;
                    break;
                }
                case 39: {
                    ++this.crossLoc.x;
                    if (this.crossLoc.x < n2) break;
                    this.crossLoc.x = n2 - 1;
                    break;
                }
                case 38: {
                    --this.crossLoc.y;
                    if (this.crossLoc.y >= 0) break;
                    this.crossLoc.y = 0;
                    break;
                }
                case 40: {
                    ++this.crossLoc.y;
                    if (this.crossLoc.y < n3) break;
                    this.crossLoc.y = n3 - 1;
                    break;
                }
                default: {
                    return;
                }
            }
            this.update();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void imageClosed(ImagePlus imagePlus) {
        this.dispose();
    }

    public void imageOpened(ImagePlus imagePlus) {
    }

    public void imageUpdated(ImagePlus imagePlus) {
        if (imagePlus == this.imp) {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            this.min = imageProcessor.getMin();
            this.max = imageProcessor.getMax();
            this.update();
        }
    }

    public String commandExecuting(String string) {
        if (string.equals("In") || string.equals("Out")) {
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus == null) {
                return string;
            }
            if (imagePlus == this.imp) {
                ImageCanvas imageCanvas = this.imp.getCanvas();
                if (imageCanvas == null) {
                    return null;
                }
                int n = imageCanvas.screenX(this.crossLoc.x);
                int n2 = imageCanvas.screenY(this.crossLoc.y);
                if (string.equals("In")) {
                    imageCanvas.zoomIn(n, n2);
                    if (imageCanvas.getMagnification() <= 1.0) {
                        this.imp.repaintWindow();
                    }
                } else {
                    imageCanvas.zoomOut(n, n2);
                    if (imageCanvas.getMagnification() < 1.0) {
                        this.imp.repaintWindow();
                    }
                }
                this.xyX = this.crossLoc.x;
                this.xyY = this.crossLoc.y;
                this.update();
                return null;
            }
            if (imagePlus == this.xz_image || imagePlus == this.yz_image) {
                this.syncZoom = false;
                return string;
            }
            return string;
        }
        if (string.equals("Flip Vertically") && this.xz_image != null) {
            if (this.xz_image == WindowManager.getCurrentImage()) {
                this.flipXZ = !this.flipXZ;
                this.update();
                return null;
            }
            return string;
        }
        return string;
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.arrangeWindows(sticky);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.arrangeWindows(sticky);
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.update();
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getSource().equals(this.xz_image.getWindow())) {
            this.crossLoc.y += mouseWheelEvent.getWheelRotation();
        } else if (mouseWheelEvent.getSource().equals(this.yz_image.getWindow())) {
            this.crossLoc.x += mouseWheelEvent.getWheelRotation();
        }
        this.update();
    }

    public void focusGained(FocusEvent focusEvent) {
        ImageCanvas imageCanvas = this.imp.getCanvas();
        if (imageCanvas != null) {
            this.canvas.requestFocus();
        }
        this.arrangeWindows(sticky);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.arrangeWindows(sticky);
    }

    public static ImagePlus getImage() {
        if (instance != null) {
            return Orthogonal_Views.instance.imp;
        }
        return null;
    }

    public static synchronized boolean isOrthoViewsImage(ImagePlus imagePlus) {
        if (imagePlus == null || instance == null) {
            return false;
        }
        return imagePlus == Orthogonal_Views.instance.imp || imagePlus == Orthogonal_Views.instance.xz_image || imagePlus == Orthogonal_Views.instance.yz_image;
    }

    public static Orthogonal_Views getInstance() {
        return instance;
    }

    public int[] getCrossLoc() {
        int[] nArray = new int[]{this.crossLoc.x, this.crossLoc.y, this.imp.getCurrentSlice() - 1};
        return nArray;
    }

    public void setCrossLoc(int n, int n2, int n3) {
        this.crossLoc.setLocation(n, n2);
        this.imp.setSlice(n3 + 1);
        this.update();
    }

    public ImagePlus getXZImage() {
        return this.xz_image;
    }

    public ImagePlus getYZImage() {
        return this.yz_image;
    }

    private class Updater
    extends Thread {
        long request;

        Updater() {
            super("Othogonal Views Updater");
            this.request = 0L;
            this.setPriority(5);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doUpdate() {
            if (this.isInterrupted()) {
                return;
            }
            Updater updater = this;
            synchronized (updater) {
                ++this.request;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void quit() {
            IJ.wait(10);
            this.interrupt();
            Updater updater = this;
            synchronized (updater) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    long l;
                    Updater updater = this;
                    synchronized (updater) {
                        l = this.request;
                    }
                    if (l > 0L) {
                        Orthogonal_Views.this.exec();
                    }
                    updater = this;
                    synchronized (updater) {
                        if (l == this.request) {
                            this.request = 0L;
                            this.wait();
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

