/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.Locator;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocatorURL
implements Locator {
    static Log log = LogFactory.getLog((Class)LocatorURL.class);
    static final String acceptHeader = "application/rdf+xml,application/xml;q=0.9,*/*;q=0.5";

    public InputStream open(String filenameOrURI) {
        if (!this.hasScheme(filenameOrURI, "http:")) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Not found: " + filenameOrURI));
            }
            return null;
        }
        try {
            URL url = new URL(filenameOrURI);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Accept", acceptHeader);
            conn.setRequestProperty("Accept-Charset", "utf-8,*");
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.connect();
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            if (in == null) {
                if (FileManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace((Object)("Not found: " + filenameOrURI));
                }
                return null;
            }
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Found: " + filenameOrURI));
            }
            return in;
        }
        catch (FileNotFoundException ex) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("LocatorURL: not found: " + filenameOrURI));
            }
            return null;
        }
        catch (MalformedURLException ex) {
            log.warn((Object)("Malformed URL: " + filenameOrURI));
            return null;
        }
        catch (IOException ex) {
            if (ex instanceof ConnectException) {
                if (FileManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace((Object)("LocatorURL: not found: " + filenameOrURI));
                }
            } else {
                log.warn((Object)("IO Exception opening URL: " + filenameOrURI + "  " + ex.getMessage()));
            }
            return null;
        }
    }

    public String getName() {
        return "LocatorURL";
    }

    private boolean hasScheme(String uri, String scheme) {
        String actualScheme = this.getScheme(uri);
        if (actualScheme == null) {
            return false;
        }
        return actualScheme.equalsIgnoreCase(scheme);
    }

    private String getScheme(String uri) {
        int ch = uri.indexOf(58);
        if (ch < 0) {
            return null;
        }
        return uri.substring(0, ch + 1);
    }
}

