/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.JDKTimeZone;
import com.ibm.icu.util.STZInfo;
import java.io.IOException;
import java.io.ObjectInputStream;

public class SimpleTimeZone
extends JDKTimeZone {
    private static final long serialVersionUID = -7034676239311322769L;
    private int raw;
    private int dst = 3600000;
    private STZInfo xinfo = null;

    public SimpleTimeZone(int rawOffset, String ID) {
        this(new java.util.SimpleTimeZone(rawOffset, ID));
        this.raw = rawOffset;
    }

    public SimpleTimeZone(int rawOffset, String ID, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime) {
        this(new java.util.SimpleTimeZone(rawOffset, ID, startMonth, startDay, startDayOfWeek, startTime, endMonth, endDay, endDayOfWeek, endTime));
        this.raw = rawOffset;
        STZInfo xinfo = this.getSTZInfo();
        xinfo.setStart(startMonth, startDay, startDayOfWeek, startTime, -1, false);
        xinfo.setEnd(endMonth, endDay, endDayOfWeek, endTime, -1, false);
    }

    public SimpleTimeZone(int rawOffset, String ID, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime, int dstSavings) {
        this(new java.util.SimpleTimeZone(rawOffset, ID, startMonth, startDay, startDayOfWeek, startTime, endMonth, endDay, endDayOfWeek, endTime, dstSavings));
        this.raw = rawOffset;
        this.dst = dstSavings;
        STZInfo xinfo = this.getSTZInfo();
        xinfo.setStart(startMonth, startDay, startDayOfWeek, startTime, -1, false);
        xinfo.setEnd(endMonth, endDay, endDayOfWeek, endTime, -1, false);
    }

    public void setRawOffset(int offsetMillis) {
        super.setRawOffset(offsetMillis);
        this.raw = offsetMillis;
    }

    public void setStartYear(int year) {
        this.unwrapSTZ().setStartYear(year);
        this.getSTZInfo().sy = year;
    }

    public void setStartRule(int month, int dayOfWeekInMonth, int dayOfWeek, int time) {
        this.unwrapSTZ().setStartRule(month, dayOfWeekInMonth, dayOfWeek, time);
        this.getSTZInfo().setStart(month, dayOfWeekInMonth, dayOfWeek, time, -1, false);
    }

    public void setStartRule(int month, int dayOfMonth, int time) {
        this.unwrapSTZ().setStartRule(month, dayOfMonth, time);
        this.getSTZInfo().setStart(month, -1, -1, time, dayOfMonth, false);
    }

    public void setStartRule(int month, int dayOfMonth, int dayOfWeek, int time, boolean after) {
        this.unwrapSTZ().setStartRule(month, dayOfMonth, dayOfWeek, time, after);
        this.getSTZInfo().setStart(month, -1, dayOfWeek, time, dayOfMonth, after);
    }

    public void setEndRule(int month, int dayOfWeekInMonth, int dayOfWeek, int time) {
        this.unwrapSTZ().setEndRule(month, dayOfWeekInMonth, dayOfWeek, time);
        this.getSTZInfo().setEnd(month, dayOfWeekInMonth, dayOfWeek, time, -1, false);
    }

    public void setEndRule(int month, int dayOfMonth, int time) {
        this.unwrapSTZ().setEndRule(month, dayOfMonth, time);
        this.getSTZInfo().setEnd(month, -1, -1, time, dayOfMonth, false);
    }

    public void setEndRule(int month, int dayOfMonth, int dayOfWeek, int time, boolean after) {
        this.unwrapSTZ().setEndRule(month, dayOfMonth, dayOfWeek, time, after);
        this.getSTZInfo().setEnd(month, -1, dayOfWeek, time, dayOfMonth, after);
    }

    public void setDSTSavings(int millisSavedDuringDST) {
        this.unwrapSTZ().setDSTSavings(millisSavedDuringDST);
        this.dst = millisSavedDuringDST;
    }

    public int getDSTSavings() {
        return this.unwrapSTZ().getDSTSavings();
    }

    public SimpleTimeZone(java.util.SimpleTimeZone tz) {
        super(tz);
        this.raw = tz.getRawOffset();
    }

    java.util.SimpleTimeZone unwrapSTZ() {
        return (java.util.SimpleTimeZone)this.unwrap();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!(this.zone instanceof java.util.SimpleTimeZone) || !this.zone.getID().equals(this.getID())) {
            java.util.SimpleTimeZone stz = new java.util.SimpleTimeZone(this.raw, this.getID());
            if (this.dst != 0) {
                stz.setDSTSavings(this.dst);
            }
            if (this.xinfo != null) {
                this.xinfo.applyTo(stz);
            }
            this.zone = stz;
        }
    }

    private STZInfo getSTZInfo() {
        if (this.xinfo == null) {
            this.xinfo = new STZInfo();
        }
        return this.xinfo;
    }
}

