/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.treevisualizer;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.Vector;
import weka.gui.treevisualizer.Node;

public class Edge {
    private String m_label;
    private String m_rsource;
    private String m_rtarget;
    private Node m_source;
    private Node m_target;
    private Vector m_lines;

    public Edge(String string, String string2, String string3) {
        this.m_label = string;
        this.m_rsource = string2;
        this.m_rtarget = string3;
        this.m_lines = new Vector(3, 2);
        this.breakupLabel();
    }

    public String getLabel() {
        return this.m_label;
    }

    private void breakupLabel() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.m_label.length(); ++n) {
            if (this.m_label.charAt(n) != '\n') continue;
            this.m_lines.addElement(this.m_label.substring(n2, n));
            n2 = n + 1;
        }
        this.m_lines.addElement(this.m_label.substring(n2, n));
    }

    public Dimension stringSize(FontMetrics fontMetrics) {
        String string;
        Dimension dimension = new Dimension();
        int n = 0;
        int n2 = 0;
        while ((string = this.getLine(n2)) != null) {
            ++n2;
            n = fontMetrics.stringWidth(string);
            if (n <= dimension.width) continue;
            dimension.width = n;
        }
        dimension.height = n2 * fontMetrics.getHeight();
        return dimension;
    }

    public String getLine(int n) {
        if (n < this.m_lines.size()) {
            return (String)this.m_lines.elementAt(n);
        }
        return null;
    }

    public String getRsource() {
        return this.m_rsource;
    }

    public void setRsource(String string) {
        this.m_rsource = string;
    }

    public String getRtarget() {
        return this.m_rtarget;
    }

    public void setRtarget(String string) {
        this.m_rtarget = string;
    }

    public Node getSource() {
        return this.m_source;
    }

    public void setSource(Node node) {
        this.m_source = node;
        node.addChild(this);
    }

    public Node getTarget() {
        return this.m_target;
    }

    public void setTarget(Node node) {
        this.m_target = node;
        node.setParent(this);
    }
}

